/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.io;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatMultiAbstract;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.navigator.io.FileFilterBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;

public class FileFilterBuilderImpl
implements FileFilterBuilder {
    private final IOHelper _ioHelper;
    private final ImportHolder _importHolder;

    public FileFilterBuilderImpl(IOHelper helperIO, ImportHolder holderImport) {
        this._ioHelper = helperIO;
        this._importHolder = holderImport;
    }

    @Override
    public CombinationFileFilter buildFileFilter() {
        ImportFormat[] formats;
        CombinationFileFilter fileFilter = this._ioHelper.getFileFilter();
        for (ImportFormat format : formats = this._importHolder.allImportFormats()) {
            FileFilterBuilderImpl.addImportFormat(fileFilter, format);
        }
        fileFilter.addAll(this.getExternalFileTypes());
        fileFilter.allowDirectory(true);
        fileFilter.allowHidden(false);
        return fileFilter;
    }

    @Override
    public boolean isExternallyOpenedFile(File file) {
        CombinationFileFilter fileFilter = new CombinationFileFilter("temp");
        fileFilter.addAll(this.getExternalFileTypes());
        return fileFilter.accept(file);
    }

    private static void addImportFormat(CombinationFileFilter target, ImportFormat format) {
        if (format instanceof ImportFormatMultiAbstract) {
            ImportFormat[] allImportFormats;
            ImportFormatMultiAbstract multiFormat = (ImportFormatMultiAbstract)format;
            for (ImportFormat importFormat2 : allImportFormats = multiFormat.allImportFormats()) {
                FileFilterBuilderImpl.addImportFormat(target, importFormat2);
            }
            return;
        }
        if (format.fileFilter() instanceof ExtensionFileFilter) {
            target.add((ExtensionFileFilter)format.fileFilter());
            return;
        }
        throw new RuntimeException(String.format("Unsupported import format: %s", format.getClass()));
    }

    private Collection<SimpleFileFilter> getExternalFileTypes() {
        return Arrays.asList(new SimpleFileFilter("kb", "Knowledge Base"), new SimpleFileFilter("java", "Java Sourcecode"), new SimpleFileFilter("jsp", "Java Servlet Pages"), new SimpleFileFilter("xml", "Extensible Markup Language"), new SimpleFileFilter("xmi", "XML Metadata Interchange"), new SimpleFileFilter("md", "Markdown"), new SimpleFileFilter("tex", "LaTeX file"), new SimpleFileFilter("html", "Hypertext"), new SimpleFileFilter("cfg", "Configuration"), new SimpleFileFilter("gif", "Graphics Interchange Format"), new SimpleFileFilter("png", "Portable Network Graphics"), new SimpleFileFilter("jpg", "Joint Photographic experts Group"), new SimpleFileFilter("jpeg", "Joint Photographic Experts Group"));
    }
}

