/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.jfiglet;

import java.io.UnsupportedEncodingException;
import org.gnu.jfiglet.core.FIGCharacter;
import org.gnu.jfiglet.core.FIGFont;
import org.gnu.jfiglet.core.FIGFontLayout;
import org.gnu.jfiglet.core.FIGure;

public class FIGDriver {
    public static final String LATIN_1_CHARSET = "ISO-8859-1";

    public FIGure getBannerFIGure(String theStringToFigletize, FIGFont theFIGFontToUse) throws UnsupportedEncodingException {
        FIGure returnedFIGure = new FIGure();
        byte[] theStringToFigletizeCharacterCodes = theStringToFigletize.getBytes(LATIN_1_CHARSET);
        this.addLineToFIGure(returnedFIGure, theStringToFigletizeCharacterCodes, theFIGFontToUse);
        return returnedFIGure;
    }

    public void addLineToFIGure(FIGure theFIGure, byte[] theLineContent, FIGFont theFIGFontToUse) {
        if (theLineContent == null || theFIGFontToUse == null || theFIGure == null) {
            throw new IllegalArgumentException("The FIGure, the line content and the FIGFont to use musn't be null.");
        }
        FIGFontLayout layout = theFIGFontToUse.getInfo().getLayout();
        String[] newLine = null;
        switch (layout.getHorizontalMode()) {
            case 0: {
                newLine = this.getFullWidthLine(theLineContent, theFIGFontToUse);
                break;
            }
            case 1: {
                newLine = this.getFittingLine(theLineContent, theFIGFontToUse);
                break;
            }
            default: {
                newLine = this.getFittingLine(theLineContent, theFIGFontToUse);
            }
        }
        theFIGure.addFigCharactersLine(newLine);
    }

    private String[] getFullWidthLine(byte[] theLineContent, FIGFont theFIGFontToUse) {
        int sublineNumber;
        String[] newLine = new String[theFIGFontToUse.getInfo().getHeight()];
        for (sublineNumber = 0; sublineNumber < newLine.length; ++sublineNumber) {
            newLine[sublineNumber] = "";
        }
        if (theLineContent.length > 0) {
            for (sublineNumber = 0; sublineNumber < newLine.length; ++sublineNumber) {
                for (int currentCharIndex = 0; currentCharIndex < theLineContent.length; ++currentCharIndex) {
                    Byte currentCharacterCode = new Byte(theLineContent[currentCharIndex]);
                    FIGCharacter currentFIGCharacter = theFIGFontToUse.getFIGCharacter(currentCharacterCode.intValue());
                    String currentFIGCharacterLine = currentFIGCharacter.getCharacterLine(sublineNumber);
                    int n = sublineNumber;
                    newLine[n] = newLine[n] + currentFIGCharacterLine.substring(0, currentFIGCharacterLine.length());
                }
                newLine[sublineNumber] = newLine[sublineNumber].replace(theFIGFontToUse.getInfo().getHardblank(), ' ');
            }
        }
        return newLine;
    }

    private String[] getFittingLine(byte[] theLineContent, FIGFont theFIGFontToUse) {
        String[] newLine = new String[theFIGFontToUse.getInfo().getHeight()];
        for (int sublineNumber = 0; sublineNumber < newLine.length; ++sublineNumber) {
            newLine[sublineNumber] = "";
        }
        if (theLineContent.length > 0) {
            int lineNumber;
            FIGCharacter lastFIGCharacterInNewLine = theFIGFontToUse.getFIGCharacter(new Byte(theLineContent[0]).intValue());
            for (lineNumber = 0; lineNumber < newLine.length; ++lineNumber) {
                newLine[lineNumber] = lastFIGCharacterInNewLine.getCharacterLine(lineNumber);
            }
            for (int charIndex = 1; charIndex < theLineContent.length; ++charIndex) {
                int lineNumber2;
                FIGCharacter figCharacterToPutInNewLine = theFIGFontToUse.getFIGCharacter(new Byte(theLineContent[charIndex]).intValue());
                int numberOfSpacesToTrim = 0;
                for (lineNumber2 = 0; lineNumber2 < newLine.length; ++lineNumber2) {
                    int numberOfSpacesBetweenCharsInThisLine = lastFIGCharacterInNewLine.getNumberOfBackSpacesForLine(lineNumber2) + figCharacterToPutInNewLine.getNumberOfFrontSpacesForLine(lineNumber2);
                    if (numberOfSpacesToTrim != 0 && numberOfSpacesBetweenCharsInThisLine >= numberOfSpacesToTrim) continue;
                    numberOfSpacesToTrim = numberOfSpacesBetweenCharsInThisLine;
                }
                for (lineNumber2 = 0; lineNumber2 < newLine.length; ++lineNumber2) {
                    int numberOfSpacesToTrimInFrontOfNewChar = Math.min(figCharacterToPutInNewLine.getNumberOfFrontSpacesForLine(lineNumber2), numberOfSpacesToTrim);
                    int numberOfSpacesToTrimAtEndOfNewLine = numberOfSpacesToTrim - numberOfSpacesToTrimInFrontOfNewChar;
                    newLine[lineNumber2] = newLine[lineNumber2].substring(0, newLine[lineNumber2].length() - numberOfSpacesToTrimAtEndOfNewLine) + figCharacterToPutInNewLine.getCharacterLine(lineNumber2).substring(numberOfSpacesToTrimInFrontOfNewChar);
                }
                lastFIGCharacterInNewLine = figCharacterToPutInNewLine;
            }
            for (lineNumber = 0; lineNumber < newLine.length; ++lineNumber) {
                newLine[lineNumber] = newLine[lineNumber].replace(theFIGFontToUse.getInfo().getHardblank(), ' ');
            }
        }
        return newLine;
    }
}

