/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.jfiglet.core;

public class FIGCharacter {
    private String[] characterLines = null;
    private int[] numbersOfFrontSpaces = null;
    private int[] numbersOfBackSpaces = null;

    public FIGCharacter(String[] theCharacterLines) {
        if (theCharacterLines == null || theCharacterLines.length == 0) {
            throw new IllegalArgumentException("the character lines musn't be null or empty");
        }
        this.characterLines = theCharacterLines;
        this.trimArobase();
        this.numbersOfFrontSpaces = new int[theCharacterLines.length];
        this.numbersOfBackSpaces = new int[theCharacterLines.length];
        this.initFIGCharacterInformations();
    }

    public String[] getCharacterLines() {
        return this.characterLines;
    }

    public String getCharacterLine(int theLineNumber) {
        try {
            return this.characterLines[theLineNumber];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public int getNumberOfFrontSpacesForLine(int theLineNumber) {
        try {
            return this.numbersOfFrontSpaces[theLineNumber];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public int getNumberOfBackSpacesForLine(int theLineNumber) {
        try {
            return this.numbersOfBackSpaces[theLineNumber];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    private void initFIGCharacterInformations() {
        for (int lineNumber = 0; lineNumber < this.characterLines.length; ++lineNumber) {
            this.numbersOfFrontSpaces[lineNumber] = 0;
            String currentLine = this.characterLines[lineNumber];
            while (this.numbersOfFrontSpaces[lineNumber] < currentLine.length() && currentLine.charAt(this.numbersOfFrontSpaces[lineNumber]) == ' ') {
                int n = lineNumber;
                this.numbersOfFrontSpaces[n] = this.numbersOfFrontSpaces[n] + 1;
            }
            int lengthOftrimedLine = currentLine.trim().length();
            this.numbersOfBackSpaces[lineNumber] = currentLine.length() - lengthOftrimedLine - this.numbersOfFrontSpaces[lineNumber];
        }
    }

    private void trimArobase() {
        for (int lineNumber = 0; lineNumber < this.characterLines.length; ++lineNumber) {
            this.characterLines[lineNumber] = this.characterLines[lineNumber].replaceAll("@", "");
        }
    }
}

