/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.simulatorontology.loading.PathlessFinder;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class AddPluginNetsExtension
implements SimulatorExtension,
PathlessFinder {
    private static final Logger LOGGER = Logger.getLogger(AddPluginNetsExtension.class);
    private JarFile[] _jarRes = null;
    private Map<String, ShadowNetSystem> _netSnsMap = null;
    private static final String SNS_EXTENSION = ".sns";

    public AddPluginNetsExtension(URL resPath) {
        LOGGER.debug((Object)("AddPluginNetsExtension with URL " + String.valueOf(resPath)));
        try {
            URL[] urls = AbstractPluginLoader.unifyURL((URL)resPath);
            this._jarRes = new JarFile[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                this._jarRes[i] = new JarFile(new File(urls[i].toURI()));
            }
        }
        catch (IOException | URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Resource path " + String.valueOf(resPath) + " is not a valid jar file: " + String.valueOf(e)), (Throwable)e);
            }
            LOGGER.warn((Object)("Resource path " + String.valueOf(resPath) + " is not a valid jar file."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulationSetup(SimulationEnvironment env) {
        AddPluginNetsExtension addPluginNetsExtension = this;
        synchronized (addPluginNetsExtension) {
            this._netSnsMap = null;
        }
    }

    public void netsCompiled(ShadowCompilationResult result) {
    }

    protected synchronized Map<String, ShadowNetSystem> getNetSnsMap() {
        if (this._netSnsMap != null) {
            return this._netSnsMap;
        }
        this._netSnsMap = new HashMap<String, ShadowNetSystem>();
        for (JarFile jf : this._jarRes) {
            LOGGER.debug((Object)("AddPluginNetsExtension: Building net-to-sns map for " + jf.getName()));
            Enumeration<JarEntry> entries = jf.entries();
            String fileName = null;
            while (entries.hasMoreElements()) {
                try {
                    Object o;
                    ZipEntry element = entries.nextElement();
                    fileName = element.toString();
                    if (!element.getName().endsWith(SNS_EXTENSION) || !((o = new ObjectInputStreamUsingBottomLoader(jf.getInputStream(element)).readObject()) instanceof ShadowNetSystem)) continue;
                    ShadowNetSystem newSns = (ShadowNetSystem)o;
                    LOGGER.debug((Object)("AddPluginNetsExtension: adding sns file " + fileName));
                    for (ShadowNet net : newSns.elements()) {
                        String netName = net.getName();
                        if (this._netSnsMap.containsKey(netName)) {
                            LOGGER.warn((Object)("AddPluginNetsExtension: Skipping duplicate net definition for " + netName + " in sns file " + fileName + " of jar " + Arrays.toString(this._jarRes) + "."));
                            continue;
                        }
                        this._netSnsMap.put(net.getName(), newSns);
                    }
                    fileName = null;
                }
                catch (IOException | ClassNotFoundException e) {
                    LOGGER.error((Object)("AddPluginNetsExtension: Could not read shadow net system from file " + fileName + " within jar  " + Arrays.toString(this._jarRes) + " due to " + String.valueOf(e) + "."), (Throwable)e);
                }
            }
        }
        return this._netSnsMap;
    }

    public void simulationTerminated() {
    }

    public void simulationTerminating() {
    }

    public ShadowNetSystem findNetFile(String name) {
        if (LOGGER.isDebugEnabled() && this.getNetSnsMap().containsKey(name)) {
            LOGGER.debug((Object)("AddPluginNetsExtension: providing sns for net " + name + ": " + String.valueOf(this.getNetSnsMap().get(name)) + "."));
        }
        return this.getNetSnsMap().get(name);
    }
}

