/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import de.renew.net.event.TokenEvent;
import de.renew.unify.Impossible;
import de.renew.unify.TupleIndex;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultisetPlaceInstance
extends SimulatablePlaceInstance {
    public static final Logger LOGGER = Logger.getLogger(MultisetPlaceInstance.class);
    private static final long serialVersionUID = 0L;
    private int _freeTokenCount;
    private int _testedTokenCount;
    private transient TokenBag _freeTokens;
    private transient TestTokenBag _testedTokens;
    private transient TupleIndex _freeIndex;
    private transient TupleIndex _testIndex;

    MultisetPlaceInstance(NetInstance netInstance, Place place, boolean wantInitialTokens) throws Impossible {
        super(netInstance, place, wantInitialTokens);
    }

    @Override
    protected void initTokenStorage() {
        this._freeTokens = new TokenBag();
        this._testedTokens = new TestTokenBag();
        this._freeTokenCount = 0;
        this._testedTokenCount = 0;
        this._freeIndex = new TupleIndex();
        this._testIndex = new TupleIndex();
    }

    @Override
    public Set<Object> getDistinctTokens() {
        return this._freeIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTokens(Object pattern) {
        return this._freeIndex.getPossibleMatches(pattern);
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        return this._testIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTestableTokens(Object pattern) {
        return this._testIndex.getPossibleMatches(pattern);
    }

    @Override
    public int getNumberOfTokens() {
        return this._freeTokenCount;
    }

    @Override
    public int getNumberOfTestedTokens() {
        return this._testedTokenCount;
    }

    @Override
    boolean containsToken(Object token) {
        return this._freeTokens.includesAnytime(token);
    }

    @Override
    public int getTokenCount(Object token) {
        return this._freeTokens.getMultiplicity(token);
    }

    @Override
    public TimeSet getFreeTimeSet(Object token) {
        return this._freeTokens.getTimeSet(token);
    }

    @Override
    public double computeEarliestTime(Object token, TimeSet times) {
        return this._freeTokens.computeEarliestTime(token, times);
    }

    @Override
    public boolean containsTestedToken(Object token) {
        return this._testedTokens.includesTested(token);
    }

    @Override
    public boolean containsTestableToken(Object token) {
        return this.containsToken(token) || this.containsTestedToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeToken(Object token, double delay) throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._lock.lock();
        try {
            double removedTime;
            try {
                removedTime = this._freeTokens.removeWithDelay(token, delay);
            }
            catch (Exception e) {
                throw new Impossible(e);
            }
            --this._freeTokenCount;
            if (!this._freeTokens.includesAnytime(token)) {
                this._freeIndex.remove(token);
                if (!this._testedTokens.includesTested(token)) {
                    this._testIndex.remove(token);
                }
            }
            Transaction transaction = TransactionSource.get();
            try {
                transaction.removeToken(this, token, removedTime);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            this._triggerables.proposeSearch();
            TokenEvent event = new TokenEvent(this, token);
            this._listeners.tokenRemoved(event);
            this._place.getListenerSet().tokenRemoved(event);
            this.unreserve(token);
            double d = removedTime;
            return d;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double testToken(Object token) throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._lock.lock();
        try {
            boolean isTokenAlreadyTested = this._testedTokens.includesTested(token);
            boolean shouldNotifyListeners = false;
            double removedTime = SearchQueue.getTime();
            if (!isTokenAlreadyTested) {
                try {
                    removedTime = this._freeTokens.removeWithDelay(token, 0.0);
                }
                catch (Exception e) {
                    throw new Impossible(e);
                }
                ++this._testedTokenCount;
                --this._freeTokenCount;
                if (!this._freeTokens.includesAnytime(token)) {
                    this._freeIndex.remove(token);
                }
                shouldNotifyListeners = true;
            }
            this._testedTokens.addTested(token, removedTime);
            if (shouldNotifyListeners) {
                this._triggerables.proposeSearch();
                TokenEvent tokenEvent = new TokenEvent(this, token);
                this._listeners.tokenTested(tokenEvent);
                this._place.getListenerSet().tokenTested(tokenEvent);
            }
            double d = removedTime;
            return d;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractAllTokens(Vector<Object> tokens, Vector<Double> timeStamps) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._lock.lock();
        try {
            ArrayList<Object> uniqueValues = new ArrayList<Object>(this.getDistinctTokens());
            while (!uniqueValues.isEmpty()) {
                Object token = uniqueValues.remove(uniqueValues.size() - 1);
                while (this.containsToken(token)) {
                    double time = 0.0;
                    try {
                        time = this.removeToken(token, Double.NEGATIVE_INFINITY);
                    }
                    catch (Impossible e) {
                        throw new RuntimeException("Token was not removable.", e);
                    }
                    if (tokens != null) {
                        tokens.addElement(token);
                    }
                    if (timeStamps == null) continue;
                    timeStamps.addElement(time);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void internallyInsertToken(Object token, double time, boolean alreadyRegistered) {
        this.internallyInsertTokenMultiple(token, time, 1, alreadyRegistered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internallyInsertTokenMultiple(Object token, double time, int n, boolean alreadyRegistered) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        assert (n > 0) : "trying to insert non-positive number of tokens";
        this._lock.lock();
        try {
            boolean isNewToken;
            boolean bl = isNewToken = !this._freeTokens.includesAnytime(token);
            if (isNewToken) {
                boolean needsTesting;
                this._freeIndex.insert(token);
                boolean bl2 = needsTesting = !this._testedTokens.includesTested(token);
                if (needsTesting) {
                    this._testIndex.insert(token);
                }
            }
            this._freeTokens.add(token, time, n);
            this._freeTokenCount += n;
            if (!alreadyRegistered) {
                this.reserve(token, n);
            }
            this._triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, token);
            this._listeners.tokenAdded(tokenEvent);
            this._place.getListenerSet().tokenAdded(tokenEvent);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untestToken(Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._lock.lock();
        try {
            boolean needsIndexRegistration;
            boolean isCompletelyUntested;
            double time = this._testedTokens.removeTested(token);
            boolean bl = isCompletelyUntested = !this._testedTokens.includesTested(token);
            if (!isCompletelyUntested) {
                return;
            }
            boolean bl2 = needsIndexRegistration = !this._freeTokens.includesAnytime(token);
            if (needsIndexRegistration) {
                this._freeIndex.insert(token);
            }
            this._freeTokens.add(token, time);
            ++this._freeTokenCount;
            --this._testedTokenCount;
            this._triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, token);
            this._listeners.tokenUntested(tokenEvent);
            this._place.getListenerSet().tokenUntested(tokenEvent);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rOut;
        assert (SimulationThreadPool.isSimulationThread()) : "Not in a simulation thread";
        boolean isRenewStream = out instanceof RenewObjectOutputStream;
        RenewObjectOutputStream renewObjectOutputStream = rOut = isRenewStream ? (RenewObjectOutputStream)out : null;
        if (isRenewStream) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (isRenewStream) {
            rOut.delayedWriteObject((Object)this._freeTokens, (DelayedFieldOwner)this);
            rOut.delayedWriteObject((Object)this._testedTokens, (DelayedFieldOwner)this);
            rOut.endDomain((Object)this);
        } else {
            out.writeObject(this._freeTokens);
            out.writeObject(this._testedTokens);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        if (in instanceof RenewObjectInputStream) {
            return;
        }
        this._freeTokens = (TokenBag)in.readObject();
        this._testedTokens = (TestTokenBag)in.readObject();
        this.recomputeIndexes();
    }

    @Override
    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.tryReassignField(value)) {
            return;
        }
        if (value instanceof TokenBag) {
            this._freeTokens = (TokenBag)value;
        } else if (value instanceof TestTokenBag) {
            this._testedTokens = (TestTokenBag)value;
            this.recomputeIndexes();
        } else {
            throw new NotSerializableException("Value of unexpected type given to MultiSetPlaceInstance.reassignField():" + value.getClass().getName() + ".");
        }
    }

    private void recomputeIndexes() {
        this._freeIndex = new TupleIndex();
        this.addToIndex(this._freeIndex, this._freeTokens.uniqueElements());
        this._testIndex = new TupleIndex();
        this.addToIndex(this._testIndex, this._freeTokens.uniqueElements());
        this.addToIndex(this._testIndex, this._testedTokens.uniqueElements());
    }

    private void addToIndex(TupleIndex index, Collection<Object> tokenList) {
        for (Object token : tokenList) {
            index.insert(token);
        }
    }

    protected void finalize() throws Throwable {
        for (Object token : this._testIndex.getAllElements()) {
            this.unreserve(token);
        }
        super.finalize();
    }
}

