/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.TimeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class TokenBag
implements Serializable {
    private int _size = 0;
    private final Map<Object, TimeSet> _map = new HashMap<Object, TimeSet>();

    TokenBag() {
    }

    public double computeEarliestTime(Object elem, TimeSet delays) {
        TimeSet value = this._map.get(elem);
        if (value != null) {
            return value.computeEarliestTime(delays);
        }
        if (delays.getSize() == 0) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public synchronized TimeSet getTimeSet(Object elem) {
        return this._map.getOrDefault(elem, TimeSet.EMPTY);
    }

    public synchronized int getMultiplicity(Object elem) {
        TimeSet value = this._map.get(elem);
        return value != null ? value.getSize() : 0;
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this._map.keySet());
    }

    public synchronized boolean includesAnytime(Object elem) {
        return this._map.containsKey(elem);
    }

    public synchronized boolean includesBefore(Object elem, double time) {
        TimeSet times = this._map.get(elem);
        if (times == null) {
            return false;
        }
        return time >= times.earliestTime();
    }

    void add(Object elem, double time) {
        this.add(elem, time, 1);
    }

    synchronized void add(Object elem, double time, int n) {
        this._map.compute(elem, (k, times) -> times != null ? times.including(time, n) : TimeSet.make(time, n));
        this._size += n;
    }

    synchronized void removeOneOf(Object elem, double time) {
        TimeSet times = this._map.get(elem);
        if (times == null) {
            throw new RuntimeException("Negative number of tokens detected.");
        }
        if ((times = times.excluding(time)).isEmpty()) {
            this._map.remove(elem);
        } else {
            this._map.put(elem, times);
        }
        --this._size;
    }

    synchronized double removeWithDelay(Object elem, double delay) {
        TimeSet times = this._map.get(elem);
        if (times == null) {
            throw new NoSuchElementException();
        }
        double time = times.latestWithDelay(delay, SearchQueue.getTime());
        if ((times = times.excluding(time)).isEmpty()) {
            this._map.remove(elem);
        } else {
            this._map.put(elem, times);
        }
        --this._size;
        return time;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TokenBag(size: ");
        buffer.append(this._size);
        buffer.append("; token@timeset:");
        for (Object token : this._map.keySet()) {
            buffer.append(' ');
            buffer.append(token);
            buffer.append('@');
            buffer.append(this._map.get(token));
        }
        buffer.append(')');
        return buffer.toString();
    }
}

