/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TransitionInstance
implements Searchable,
Triggerable,
UplinkProvider,
TransitionEventProducer,
Serializable,
DelayedFieldOwner {
    private static final long serialVersionUID = -2146903280470015837L;
    private final NetInstance _netInstance;
    private final Transition _transition;
    private transient TriggerCollection _triggers = new TriggerCollectionImpl(this);
    private transient Set<FiringEvent> _pendingEvents = new HashSet<FiringEvent>();
    private transient TransitionEventListenerSet _listeners = new TransitionEventListenerSet();
    private transient Runnable _executeAfterDeserialization = null;

    TransitionInstance(NetInstance netInstance, Transition transition) {
        this._netInstance = netInstance;
        this._transition = transition;
    }

    public String toString() {
        return this._netInstance.toString() + "." + this._transition.toString();
    }

    public NetInstance getNetInstance() {
        return this._netInstance;
    }

    public Transition getTransition() {
        return this._transition;
    }

    @Override
    public TriggerCollection triggers() {
        return this._triggers;
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener listener) {
        this._listeners.addTransitionEventListener(listener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener listener) {
        this._listeners.removeTransitionEventListener(listener);
    }

    @Override
    public void proposeSearch() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    synchronized void firingStarted(FiringEvent fe) {
        this._pendingEvents.add(fe);
        this._listeners.firingStarted(fe);
        this._transition.getListenerSet().firingStarted(fe);
    }

    synchronized void firingComplete(FiringEvent fe) {
        this._pendingEvents.remove(fe);
        this._listeners.firingComplete(fe);
        this._transition.getListenerSet().firingComplete(fe);
    }

    public Iterator<FiringEvent> pendingFiringEvents() {
        return this._pendingEvents.iterator();
    }

    public synchronized boolean isFiring() {
        return !this._pendingEvents.isEmpty();
    }

    void createConfirmation() {
        if (this._transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    public boolean listensToChannel(String channel) {
        return this._transition.listensToChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSearchOccurrence(Variable params, Searcher searcher) {
        int checkpoint = searcher.getStateRecorder().checkpoint();
        try {
            searcher.search(new TransitionOccurrence(this, params, searcher));
        }
        catch (Impossible impossible) {
        }
        finally {
            searcher.getStateRecorder().restore(checkpoint);
        }
    }

    @Override
    public void bindChannel(Variable params, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(params, searcher);
    }

    @Override
    public void startSearch(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(null, searcher);
        searcher.getStateRecorder().restore();
    }

    public boolean fireOneBinding(boolean asynchronous, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ExecuteFinder finder = new ExecuteFinder();
        SimulatorHelper.searchOnce(searcher, finder, this, this);
        StepIdentifier step = SimulationManager.getCurrentSimulator().nextStepIdentifier();
        if (finder.isCompleted()) {
            finder.execute(step, asynchronous);
            return true;
        }
        return false;
    }

    public boolean fireOneBinding(boolean asynchronous) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Searcher searcher = new Searcher();
        return this.fireOneBinding(asynchronous, searcher);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        if (this._pendingEvents.isEmpty()) {
            out.defaultWriteObject();
            if (rOut != null) {
                rOut.delayedWriteObject((Object)this._triggers, (DelayedFieldOwner)this);
            } else {
                out.writeObject(this._triggers);
            }
        } else {
            throw new NotSerializableException("Active bindings  at transition instance " + String.valueOf(this));
        }
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this._pendingEvents = new HashSet<FiringEvent>();
        this._listeners = new TransitionEventListenerSet();
        if (in instanceof RenewObjectInputStream) {
            RenewObjectInputStream rIn = (RenewObjectInputStream)in;
            if (rIn.isCopiousBehaviour()) {
                TransitionInstance tiRef = this;
                this._executeAfterDeserialization = () -> {
                    assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                    if (this._transition.isSpontaneous()) {
                        SearchQueue.includeNow(tiRef);
                    }
                };
            }
        } else {
            this._triggers = (TriggerCollection)in.readObject();
        }
    }

    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!(value instanceof TriggerCollection)) {
            throw new NotSerializableException("Value of unexpected type given to reassign().");
        }
        this._triggers = (TriggerCollection)value;
        if (this._executeAfterDeserialization != null) {
            this._executeAfterDeserialization.run();
            this._executeAfterDeserialization = null;
        }
    }
}

