/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.HashSet;
import java.util.Set;

public final class CalculationChecker
implements ICalculationChecker {
    private final Set<Variable> _lateVariables = new HashSet<Variable>();
    private final Set<Variable> _earlyVariables = new HashSet<Variable>();

    @Override
    public void reset() {
        this._lateVariables.clear();
        this._earlyVariables.clear();
    }

    @Override
    public void addEarlyVariable(Variable var, IStateRecorder recorder) throws Impossible {
        if (!this._earlyVariables.contains(var)) {
            if (recorder != null) {
                recorder.record(() -> this._earlyVariables.remove(var));
            }
            this._earlyVariables.add(var);
        }
    }

    @Override
    public void addCalculated(Class<?> targetType, Object target, Object source, IStateRecorder recorder) throws Impossible {
        Unify.unify(target, new Calculator(targetType, source, recorder), recorder);
    }

    @Override
    public void addLateVariable(Variable var, IStateRecorder recorder) throws Impossible {
        if (!this._lateVariables.contains(var)) {
            if (recorder != null) {
                recorder.record(() -> this._lateVariables.remove(var));
            }
            this._lateVariables.add(var);
        }
    }

    @Override
    public boolean isConsistent() {
        return this.checkLateVariables() && this.checkEarlyVariables();
    }

    private boolean checkLateVariables() {
        return this._lateVariables.stream().allMatch(Variable::isComplete);
    }

    private boolean checkEarlyVariables() {
        return this._earlyVariables.stream().allMatch(Variable::isBound);
    }
}

