/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.dock.dockable.DefaultDockableMovingImageFactory;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.span.DefaultSpanFactory;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeCombiner;
import bibliothek.gui.dock.themes.ThemeDisplayerFactory;
import bibliothek.gui.dock.themes.ThemeDockableSelection;
import bibliothek.gui.dock.themes.ThemeStationPaint;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;

public interface DockTheme {
    public static final PropertyKey<BackgroundPaint> BACKGROUND_PAINT = new PropertyKey("dock.background");
    public static final PropertyKey<BorderModifier> BORDER_MODIFIER = new PropertyKey("dock.borderModifier");
    public static final PropertyKey<SpanFactory> SPAN_FACTORY = new PropertyKey<DefaultSpanFactory>("span factory", new ConstantPropertyFactory<DefaultSpanFactory>(new DefaultSpanFactory()), true);
    public static final PropertyKey<Combiner> COMBINER = new PropertyKey<Combiner>("dock.combiner", new DynamicPropertyFactory<Combiner>(){

        @Override
        public Combiner getDefault(PropertyKey<Combiner> key, DockProperties properties) {
            return new ThemeCombiner(properties.getController());
        }
    }, true);
    public static final PropertyKey<StationPaint> STATION_PAINT = new PropertyKey<StationPaint>("dock.paint", new DynamicPropertyFactory<StationPaint>(){

        @Override
        public StationPaint getDefault(PropertyKey<StationPaint> key, DockProperties properties) {
            return new ThemeStationPaint(properties.getController());
        }
    }, true);
    public static final PropertyKey<DisplayerFactory> DISPLAYER_FACTORY = new PropertyKey<DisplayerFactory>("dock.displayerFactory", new DynamicPropertyFactory<DisplayerFactory>(){

        @Override
        public DisplayerFactory getDefault(PropertyKey<DisplayerFactory> key, DockProperties properties) {
            return new ThemeDisplayerFactory(properties.getController());
        }
    }, true);
    public static final PropertyKey<DockableMovingImageFactory> DOCKABLE_MOVING_IMAGE_FACTORY = new PropertyKey<DockableMovingImageFactory>("dock.movingImageFactory", new DynamicPropertyFactory<DockableMovingImageFactory>(){

        @Override
        public DockableMovingImageFactory getDefault(PropertyKey<DockableMovingImageFactory> key, DockProperties properties) {
            return new DefaultDockableMovingImageFactory(properties.getController());
        }
    }, true);
    public static final PropertyKey<DockableSelection> DOCKABLE_SELECTION = new PropertyKey<DockableSelection>("dock.dockableSelection", new DynamicPropertyFactory<DockableSelection>(){

        @Override
        public DockableSelection getDefault(PropertyKey<DockableSelection> key, DockProperties properties) {
            return new ThemeDockableSelection(properties.getController());
        }
    }, true);

    public void install(DockController var1, DockThemeExtension[] var2);

    public void uninstall(DockController var1);

    public Combiner getCombiner(DockStation var1);

    public StationPaint getPaint(DockStation var1);

    public DisplayerFactory getDisplayFactory(DockStation var1);

    public DockTitleFactory getTitleFactory(DockController var1);

    public DockableMovingImageFactory getMovingImageFactory(DockController var1);

    public DockableSelection getDockableSelection(DockController var1);
}

