/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LayeredIcon
extends ImageIcon {
    Set<Icon> iconSet = new LinkedHashSet<Icon>();

    public LayeredIcon(Image image) {
        super(image);
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        super.paintIcon(c, g2, x, y);
        Dimension d = new Dimension(this.getIconWidth(), this.getIconHeight());
        for (Icon icon : this.iconSet) {
            Dimension id = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            int dx = (d.width - id.width) / 2;
            int dy = (d.height - id.height) / 2;
            icon.paintIcon(c, g2, x + dx, y + dy);
        }
    }

    public void add(Icon icon) {
        this.iconSet.add(icon);
    }

    public boolean remove(Icon icon) {
        return this.iconSet.remove(icon);
    }
}

