/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.base.compact.AbstractCompact;
import net.automatalib.ts.powerset.DeterministicPowersetView;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactDeterministic<I, T, SP, TP>
extends AbstractCompact<I, T, SP, TP>
implements MutableDeterministic<Integer, I, T, SP, TP>,
MutableDeterministic.StateIntAbstraction<I, T, SP, TP>,
MutableDeterministic.FullIntAbstraction<T, SP, TP>,
Serializable {
    private int initial = -1;

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, AbstractCompactDeterministic<?, ?, ?, ?> other) {
        super(alphabet, other);
        this.initial = other.initial;
    }

    @Override
    public void setInitialState(@Nullable Integer state) {
        this.setInitialState(AbstractCompactDeterministic.toId(state));
    }

    @Override
    public void setInitialState(int stateId) {
        this.initial = stateId;
    }

    @Override
    public SP getStateProperty(Integer state) {
        return this.getStateProperty(state.intValue());
    }

    @Override
    public int getIntInitialState() {
        return this.initial;
    }

    @Override
    public @Nullable Integer getInitialState() {
        return AbstractCompactDeterministic.toState(this.initial);
    }

    @Override
    public @Nullable T getTransition(int state, I input) {
        return this.getTransition(state, (I)this.getSymbolIndex(input));
    }

    @Override
    public @Nullable T getTransition(Integer state, I input) {
        return this.getTransition((int)state, input);
    }

    @Override
    public void setTransition(Integer state, I input, @Nullable T transition) {
        this.setTransition((int)state, (I)this.getSymbolIndex(input), transition);
    }

    @Override
    public void setTransition(int state, I input, @Nullable T transition) {
        this.setTransition(state, (I)this.getSymbolIndex(input), transition);
    }

    @Override
    public void setTransition(int state, I input, int successor, TP property) {
        this.setTransition(state, (I)this.getSymbolIndex(input), successor, property);
    }

    @Override
    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    @Override
    public T createTransition(Integer successor, TP properties) {
        return this.createTransition(successor.intValue(), properties);
    }

    @Override
    public int addIntInitialState(@Nullable SP property) {
        this.setInitial(this.addIntState(property), true);
        return this.initial;
    }

    @Override
    public Integer getSuccessor(T transition) {
        return this.getIntSuccessor(transition);
    }

    @Override
    public void clear() {
        this.initial = -1;
        super.clear();
    }

    @Override
    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        if (Objects.equals(this.getInputAlphabet(), alphabet)) {
            return this;
        }
        return MutableDeterministic.super.fullIntAbstraction((Alphabet)alphabet);
    }

    @Override
    public MutableDeterministic.StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return this;
    }

    public DeterministicPowersetView<Integer, I, T> powersetView() {
        return new DeterministicPowersetView(this);
    }

    @Override
    public Collection<I> getLocalInputs(Integer state) {
        Alphabet alphabet = this.getInputAlphabet();
        ArrayList result = new ArrayList(alphabet.size());
        for (Object i : alphabet) {
            if (this.getTransition(state, (I)i) == null) continue;
            result.add(i);
        }
        return result;
    }
}

