/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.helpers;

import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.commons.util.mappings.MutableMapping;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StateIDGrowingMapping<S, @Nullable V>
implements MutableMapping<S, V> {
    private final StateIDs<S> stateIds;
    private final ResizingArrayStorage<V> storage;

    public StateIDGrowingMapping(StateIDs<S> stateIds, int size) {
        this.stateIds = stateIds;
        this.storage = new ResizingArrayStorage<Object>(Object.class, size);
    }

    @Override
    public V get(S elem) {
        int id = this.stateIds.getStateId(elem);
        if (id >= 0 && id < this.storage.array.length) {
            return (V)this.storage.array[id];
        }
        return null;
    }

    @Override
    public V put(S key, V value) {
        int id = this.stateIds.getStateId(key);
        if (id >= this.storage.array.length) {
            this.storage.ensureCapacity(id + 1);
        }
        Object old = this.storage.array[id];
        this.storage.array[id] = value;
        return (V)old;
    }
}

