/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.automatalib.commons.util.collections.AllCombinationsIterator;
import net.automatalib.commons.util.collections.AllTuplesIterator;
import net.automatalib.commons.util.collections.CharRange;
import net.automatalib.commons.util.collections.CharStringRange;
import net.automatalib.commons.util.collections.IntRange;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <E> @Nullable E removeReplace(List<E> list, int index) {
        int lastIdx = list.size() - 1;
        E last = list.remove(lastIdx);
        if (lastIdx != index) {
            list.set(index, last);
            return last;
        }
        return null;
    }

    public static List<Integer> intRange(int start, int end) {
        return new IntRange(start, end);
    }

    public static List<Integer> intRange(int start, int end, int step) {
        return new IntRange(start, end, step);
    }

    public static List<Character> charRange(char start, char end) {
        return new CharRange(start, end);
    }

    public static List<String> charStringRange(char start, char end) {
        return new CharStringRange(start, end);
    }

    public static <T> List<? extends T> randomAccessList(Collection<? extends T> coll) {
        if (coll instanceof List && coll instanceof RandomAccess) {
            return (List)coll;
        }
        return new ArrayList<T>(coll);
    }

    public static <T> Iterable<List<T>> allTuples(Iterable<? extends T> domain, int length) {
        return CollectionsUtil.allTuples(domain, length, length);
    }

    public static <T> Iterable<List<T>> allTuples(Iterable<? extends T> domain, int minLength, int maxLength) {
        if (!domain.iterator().hasNext()) {
            if (minLength == 0) {
                return Collections.singletonList(Collections.emptyList());
            }
            return Collections.emptyList();
        }
        return () -> new AllTuplesIterator(domain, minLength, maxLength);
    }

    @SafeVarargs
    public static <T> Iterable<List<T>> cartesianProduct(Iterable<T> ... iterables) {
        if (iterables.length == 0) {
            return Collections.singletonList(Collections.emptyList());
        }
        return () -> new AllCombinationsIterator(iterables);
    }
}

