/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.base.compact.CompactEdge;
import net.automatalib.graphs.concepts.NodeIDs;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactGraph<E extends CompactEdge<EP>, NP, EP>
implements MutableGraph<Integer, E, NP, EP>,
NodeIDs<Integer> {
    protected final ResizingArrayStorage<List<E>> edges;
    protected int size;

    public AbstractCompactGraph() {
        this.edges = new ResizingArrayStorage<List>(List.class);
    }

    public AbstractCompactGraph(int initialCapacity) {
        this.edges = new ResizingArrayStorage<List>(List.class, initialCapacity);
    }

    @Override
    public Collection<Integer> getNodes() {
        return CollectionsUtil.intRange(0, this.size);
    }

    @Override
    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    @Override
    public Collection<E> getOutgoingEdges(Integer node) {
        return this.getOutgoingEdges((int)node);
    }

    @Override
    public Collection<E> getOutgoingEdges(int node) {
        return Collections.unmodifiableCollection(this.getOutEdgeList(node));
    }

    protected List<E> getOutEdgeList(int node) {
        return ((List[])this.edges.array)[node];
    }

    @Override
    public Integer getTarget(E edge) {
        return ((CompactEdge)edge).getTarget();
    }

    @Override
    public Integer addNode(@Nullable NP properties) {
        return this.addIntNode(properties);
    }

    public int addIntNode(@Nullable NP properties) {
        this.edges.ensureCapacity(this.size + 1);
        ((List[])this.edges.array)[this.size] = new ArrayList();
        int n = this.size++;
        this.setNodeProperty(n, properties);
        return n;
    }

    public int addIntNode() {
        return this.addIntNode(null);
    }

    @Override
    public void setNodeProperty(Integer node, NP property) {
        this.setNodeProperty((int)node, property);
    }

    @Override
    public abstract void setNodeProperty(int var1, @Nullable NP var2);

    @Override
    public E connect(Integer source, Integer target, @Nullable EP properties) {
        return this.connect((int)source, (int)target, properties);
    }

    @Override
    public E connect(int source, int target, @Nullable EP property) {
        E edge = this.createEdge(source, target, property);
        List<E> edges = this.getOutEdgeList(source);
        ((CompactEdge)edge).outIndex = edges.size();
        edges.add(edge);
        return edge;
    }

    @Override
    public CompactEdge<EP> connect(int source, int target) {
        return this.connect(source, target, (EP)null);
    }

    protected abstract E createEdge(int var1, int var2, @Nullable EP var3);

    @Override
    public void setEdgeProperty(E edge, EP property) {
        ((CompactEdge)edge).setProperty(property);
    }

    @Override
    public int getNodeId(Integer node) {
        return node;
    }

    @Override
    public Integer getNode(int id) {
        return id;
    }

    @Override
    public NP getNodeProperty(Integer node) {
        return this.getNodeProperties(node);
    }

    public abstract NP getNodeProperties(int var1);

    @Override
    public EP getEdgeProperty(E edge) {
        return ((CompactEdge)edge).getProperty();
    }
}

