/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.io.Serializable;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.StateSignature;

final class State
implements Serializable {
    public static final State SINK = new State(new StateSignature(0, Acceptance.FALSE));
    private final StateSignature signature;
    private int numIncoming;

    State(StateSignature signature) {
        this.signature = signature;
        this.numIncoming = 0;
    }

    public void increaseIncoming() {
        ++this.numIncoming;
    }

    public void decreaseIncoming() {
        --this.numIncoming;
    }

    public boolean isConfluence() {
        return this.numIncoming > 1;
    }

    public Acceptance getAcceptance() {
        if (this.signature == null) {
            return Acceptance.FALSE;
        }
        return this.signature.acceptance;
    }

    public State getSuccessor(int idx) {
        return ((State[])this.signature.successors.array)[idx];
    }

    public StateSignature getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.isSink()) {
            return "sink";
        }
        return "s";
    }

    public boolean isSink() {
        return this == SINK;
    }

    boolean ensureInputCapacity(int capacity) {
        return this.signature.successors.ensureCapacity(capacity);
    }
}

