/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.tree.Edge;
import net.automatalib.incremental.dfa.tree.Node;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.helper.DelegateVisualizationHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import net.automatalib.words.impl.Alphabets;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalDFATreeBuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    protected final Node<I> root = new Node();

    public IncrementalDFATreeBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.inputAlphabet.size())) {
            this.ensureInputCapacity(this.root, this.alphabetSize, newAlphabetSize);
            this.alphabetSize = newAlphabetSize;
        }
    }

    private void ensureInputCapacity(Node<I> node, int oldAlphabetSize, int newAlphabetSize) {
        node.ensureInputCapacity(newAlphabetSize);
        for (int i = 0; i < oldAlphabetSize; ++i) {
            Node<I> child = node.getChild(i);
            if (child == null) continue;
            this.ensureInputCapacity(child, oldAlphabetSize, newAlphabetSize);
        }
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(DFA<?, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected <S> @Nullable Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Object automatonInit = target.getInitialState();
        if (this.root.getAcceptance().conflicts(automatonInit != null && target.isAccepting(automatonInit))) {
            return Word.epsilon();
        }
        Record<@Nullable S, ? extends I> init = new Record(automatonInit, this.root, null, inputs.iterator());
        ArrayDeque<Record<@Nullable Object, ? extends I>> dfsStack = new ArrayDeque<Record<Object, ? extends I>>();
        dfsStack.push(init);
        while (!dfsStack.isEmpty()) {
            boolean succAcc;
            Object automatonSucc;
            @Nullable @NonNull Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            int inputIdx = this.inputAlphabet.getSymbolIndex(input);
            Node succ = rec.treeNode.getChild(inputIdx);
            if (succ == null) continue;
            @Nullable S state = rec.automatonState;
            Object s2 = automatonSucc = state == null ? null : (Object)target.getTransition(state, input);
            if (automatonSucc == null && omitUndefined) continue;
            boolean bl = succAcc = automatonSucc != null && target.isAccepting(automatonSucc);
            if (succ.getAcceptance().conflicts(succAcc)) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            dfsStack.push(new Record<Object, I>(automatonSucc, succ, input, inputs.iterator()));
        }
        return null;
    }

    @Override
    public Acceptance lookup(Word<? extends I> inputWord) {
        Node<I> curr = this.root;
        for (I sym : inputWord) {
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node<I> succ = curr.getChild(symIdx);
            if (succ == null) {
                return Acceptance.DONT_KNOW;
            }
            curr = succ;
        }
        return curr.getAcceptance();
    }

    @Override
    public void insert(Word<? extends I> word, boolean acceptance) {
        Node<I> curr = this.root;
        for (I sym : word) {
            int inputIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node<I> succ = curr.getChild(inputIdx);
            if (succ == null) {
                succ = new Node();
                curr.setChild(inputIdx, this.alphabetSize, succ);
            }
            curr = succ;
        }
        Acceptance acc = curr.getAcceptance();
        Acceptance newWordAcc = Acceptance.fromBoolean(acceptance);
        if (acc == Acceptance.DONT_KNOW) {
            curr.setAcceptance(newWordAcc);
        } else if (acc != newWordAcc) {
            throw new ConflictException("Conflicting acceptance values for word " + word + ": " + (Object)((Object)acc) + " vs " + (Object)((Object)newWordAcc));
        }
    }

    @Override
    public GraphView asGraph() {
        return new GraphView();
    }

    @Override
    public TransitionSystemView asTransitionSystem() {
        return new TransitionSystemView();
    }

    public class TransitionSystemView
    extends AbstractIncrementalDFABuilder.AbstractTransitionSystemView<Node<I>, I, Node<I>> {
        @Override
        public Node<I> getSuccessor(Node<I> transition) {
            return transition;
        }

        @Override
        public @Nullable Node<I> getTransition(Node<I> state, I input) {
            int inputIdx = IncrementalDFATreeBuilder.this.inputAlphabet.getSymbolIndex(input);
            return state.getChild(inputIdx);
        }

        @Override
        public Node<I> getInitialState() {
            return IncrementalDFATreeBuilder.this.root;
        }

        @Override
        public Acceptance getAcceptance(Node<I> state) {
            return state.getAcceptance();
        }
    }

    public class GraphView
    extends AbstractIncrementalDFABuilder.AbstractGraphView<I, Node<I>, Edge<I>> {
        @Override
        public Collection<Node<I>> getNodes() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, GraphTraversal.dfIterator(this, Collections.singleton(IncrementalDFATreeBuilder.this.root)));
            return result;
        }

        @Override
        public Collection<Edge<I>> getOutgoingEdges(Node<I> node) {
            ArrayList result = new ArrayList(IncrementalDFATreeBuilder.this.alphabetSize);
            for (int i = 0; i < IncrementalDFATreeBuilder.this.alphabetSize; ++i) {
                Node succ = node.getChild(i);
                if (succ == null) continue;
                result.add(new Edge(succ, IncrementalDFATreeBuilder.this.inputAlphabet.getSymbol(i)));
            }
            return result;
        }

        @Override
        public Node<I> getTarget(Edge<I> edge) {
            return edge.getNode();
        }

        @Override
        public I getInputSymbol(Edge<I> edge) {
            return edge.getInput();
        }

        @Override
        public Acceptance getAcceptance(Node<I> node) {
            return node.getAcceptance();
        }

        @Override
        public Node<I> getInitialNode() {
            return IncrementalDFATreeBuilder.this.root;
        }

        @Override
        public VisualizationHelper<Node<I>, Edge<I>> getVisualizationHelper() {
            return new DelegateVisualizationHelper<Node<I>, Edge<I>>(super.getVisualizationHelper()){
                private int id;

                @Override
                public boolean getNodeProperties(Node<I> node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    properties.put("label", "n" + this.id++);
                    return true;
                }
            };
        }
    }

    protected static final class Record<S, I> {
        public final S automatonState;
        public final Node<I> treeNode;
        public final I incomingInput;
        public final Iterator<? extends I> inputIt;

        public Record(S automatonState, Node<I> treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.incomingInput = incomingInput;
            this.inputIt = inputIt;
        }
    }
}

