/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.ltl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminDFA;
import net.automatalib.modelcheckers.ltsmin.LTSminLTLParser;
import net.automatalib.modelcheckers.ltsmin.ltl.AbstractLTSminLTL;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;
import net.automatalib.modelchecking.lasso.DFALassoImpl;
import net.automatalib.serialization.fsm.parser.FSM2DFAParser;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTSminLTLDFA<I>
extends AbstractLTSminLTL<I, DFA<?, I>, Lasso.DFALasso<I>>
implements ModelCheckerLasso.DFAModelCheckerLasso<I, String>,
LTSminDFA<I, Lasso.DFALasso<I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminLTLDFA.class);
    public static final String LABEL_NAME = "label";
    public static final String LABEL_VALUE = "accept";

    public LTSminLTLDFA(boolean keepFiles, Function<String, I> string2Input, int minimumUnfolds, double multiplier) {
        super(keepFiles, string2Input, minimumUnfolds, multiplier);
    }

    @Override
    protected void verifyFormula(String formula) {
        LTSminLTLParser.requireValidLetterFormula(formula);
    }

    @Override
    public @Nullable Lasso.DFALasso<I> findCounterExample(DFA<?, I> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            CompactDFA dfa = (CompactDFA)FSM2DFAParser.getParser(inputs, this.getString2Input(), LABEL_NAME, LABEL_VALUE).readModel(fsm);
            DFALassoImpl<? extends I> dFALassoImpl = new DFALassoImpl<I>(dfa, inputs, this.computeUnfolds(automaton.size()));
            return dFALassoImpl;
        }
        catch (IOException | FSMFormatException e) {
            throw new ModelCheckingException(e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: " + fsm.getAbsolutePath());
            }
        }
    }
}

