/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.powerset.DirectPowersetDTS;
import net.automatalib.ts.simple.SimpleTS;

public interface TransitionSystem<S, I, T>
extends SimpleTS<S, I> {
    @Override
    default public Set<S> getSuccessors(S state, I input) {
        Collection<T> transitions = this.getTransitions(state, input);
        if (transitions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<S> result = new HashSet<S>(transitions.size());
        for (T trans : transitions) {
            result.add(this.getSuccessor(trans));
        }
        return result;
    }

    public Collection<T> getTransitions(S var1, I var2);

    public S getSuccessor(T var1);

    default public PowersetViewTS<?, I, ?, S, T> powersetView() {
        return new DirectPowersetDTS(this);
    }
}

