/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.conformance;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.util.collections.AbstractThreeLevelIterator;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.collections.ReusableIterator;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.util.automata.equivalence.CharacterizingSets;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WpMethodTestsIterator<I>
extends ForwardingIterator<Word<I>> {
    private final Iterator<Word<I>> wpIterator;

    public WpMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, int maxDepth) {
        HashSet stateCover = Sets.newHashSetWithExpectedSize(automaton.size());
        HashSet transitionCover = Sets.newHashSetWithExpectedSize(automaton.size() * inputs.size());
        Covers.cover(automaton, inputs, stateCover, transitionCover);
        Iterator<Word<I>> characterizingIter = CharacterizingSets.characterizingSetIterator(automaton, inputs);
        Iterable<Word<Object>> characterizingSet = !characterizingIter.hasNext() ? Collections.singletonList(Word.epsilon()) : new ReusableIterator<Word<? extends I>>(characterizingIter);
        FirstPhaseIterator firstIterator = new FirstPhaseIterator(stateCover, CollectionsUtil.allTuples(inputs, 0, maxDepth), characterizingSet);
        transitionCover.removeAll(stateCover);
        SecondPhaseIterator secondIterator = new SecondPhaseIterator(automaton, inputs, transitionCover, CollectionsUtil.allTuples(inputs, 0, maxDepth));
        this.wpIterator = Iterators.concat(firstIterator, secondIterator);
    }

    @Override
    protected Iterator<Word<I>> delegate() {
        return this.wpIterator;
    }

    private static class SecondPhaseIterator<S, I>
    extends AbstractThreeLevelIterator<List<I>, Word<I>, Word<I>, Word<I>> {
        private final UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton;
        private final Collection<? extends I> inputs;
        private final MutableMapping<S, @Nullable List<Word<I>>> localSuffixSets;
        private final Iterable<Word<I>> prefixes;
        private final WordBuilder<I> wordBuilder = new WordBuilder();

        SecondPhaseIterator(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts) {
            super(middleParts.iterator());
            this.automaton = automaton;
            this.inputs = inputs;
            this.localSuffixSets = automaton.createStaticStateMapping();
            this.prefixes = prefixes;
        }

        @Override
        protected Iterator<Word<I>> l2Iterator(List<I> l1Object) {
            return this.prefixes.iterator();
        }

        @Override
        protected Iterator<Word<I>> l3Iterator(List<I> middle, Word<I> prefix) {
            @NonNull S tmp = this.automaton.getState(prefix);
            @NonNull S state = this.automaton.getSuccessor(tmp, middle);
            @Nullable List<Word<I>> localSuffixes = (List<Word<I>>)this.localSuffixSets.get(state);
            if (localSuffixes == null) {
                localSuffixes = Automata.stateCharacterizingSet(this.automaton, this.inputs, state);
                if (localSuffixes.isEmpty()) {
                    localSuffixes = Collections.singletonList(Word.epsilon());
                }
                this.localSuffixSets.put(state, localSuffixes);
            }
            return localSuffixes.iterator();
        }

        @Override
        protected Word<I> combine(List<I> middle, Word<I> prefix, Word<I> suffix) {
            this.wordBuilder.ensureAdditionalCapacity(prefix.size() + middle.size() + suffix.size());
            Word<I> word = this.wordBuilder.append(prefix).append(middle).append(suffix).toWord();
            this.wordBuilder.clear();
            return word;
        }
    }

    private static class FirstPhaseIterator<I>
    extends AbstractThreeLevelIterator<List<I>, Word<I>, Word<I>, Word<I>> {
        private final Iterable<Word<I>> prefixes;
        private final Iterable<Word<I>> suffixes;
        private final WordBuilder<I> wordBuilder = new WordBuilder();

        FirstPhaseIterator(Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts, Iterable<Word<I>> suffixes) {
            super(middleParts.iterator());
            this.prefixes = prefixes;
            this.suffixes = suffixes;
        }

        @Override
        protected Iterator<Word<I>> l2Iterator(List<I> l1Object) {
            return this.prefixes.iterator();
        }

        @Override
        protected Iterator<Word<I>> l3Iterator(List<I> l1Object, Word<I> l2Object) {
            return this.suffixes.iterator();
        }

        @Override
        protected Word<I> combine(List<I> middle, Word<I> prefix, Word<I> suffix) {
            this.wordBuilder.ensureAdditionalCapacity(prefix.size() + middle.size() + suffix.size());
            Word<I> word = this.wordBuilder.append(prefix).append(middle).append(suffix).toWord();
            this.wordBuilder.clear();
            return word;
        }
    }
}

