package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.standard.NullDrawing;
import de.renew.draw.ui.ontology.AbstractCommand;


/**
 * A command that closes all open drawings.
 *
 * @author Michael Haustermann
 **/
public class CloseAllDrawingsCommand extends AbstractCommand {

    /**
     * Create a new command with the title "Close All Drawings"
     */
    public CloseAllDrawingsCommand() {
        super("Close All Drawings");
    }

    /**
     * This command is executable only if a drawing to close is
     * available.
     *
     * @return <code>true</code> if there exists a current drawing.
     **/
    @Override
    public final boolean isExecutable() {
        DrawApplication app = DrawPlugin.getGui();
        if (app == null) {
            return false;
        }
        return !(app.drawing() instanceof NullDrawing);
    }

    /**
     * Closes the current drawing.
     **/
    @Override
    public final void execute() {
        DrawApplication app = DrawPlugin.getGui();
        app.closeAllDrawings();
    }
}