/*
 * Created on 20.06.2003
 *
 */
package CH.ifa.draw.application;


/**
 * This Exception is thrown by the GuiPlugin Plugin
 * if the Gui Window is not open but
 * methods that depend on it are called.
 *
 * @author 6schumac
 */
public class NoGuiAvailableException extends IllegalStateException {
    /**
     * Creates a new NoGuiAvailableException containing the default message.
     */
    public NoGuiAvailableException() {
        super("No Gui Window open.");
    }

    /**
     * Creates a new NoGuiAvailableException containing a custom message.
     * @param s String that contains warning message
     */
    public NoGuiAvailableException(String s) {
        super(s);
    }
}