package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.standard.NullDrawing;
import de.renew.draw.ui.ontology.AbstractCommand;


/**
 * A command that prints a drawing.
 *
 * @author Michael Duvigneau
 **/
public class PrintDrawingCommand extends AbstractCommand {
    /**
     * Constructs a command with the name "Print Drawing...".
     */
    public PrintDrawingCommand() {
        super("Print Drawing...");
    }

    /**
     * This command is executable only if a drawing to print is
     * available.
     *
     * @return <code>true</code> if there exists a current drawing.
     **/
    @Override
    public final boolean isExecutable() {
        DrawApplication app = DrawPlugin.getGui();
        if (app == null) {
            return false;
        }
        return !(app.drawing() instanceof NullDrawing);
    }

    /**
     * Prints the current drawing.
     **/
    @Override
    public final void execute() {
        DrawApplication app = DrawPlugin.getGui();
        app.print();
    }
}