/*
 * Sun Mar  2 19:15:28 1997  Doug Lea  (dl at gee)
 * Based on RadiusHandle
 */

package CH.ifa.draw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A Handle to rotate a TriangleFigure
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
class TriangleRotationHandle extends AbstractHandle {
    private Point _center = null;

    public TriangleRotationHandle(TriangleFigure owner) {
        super(owner);
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        Rectangle displayBox = owner().displayBox();
        _center =
            new Point(displayBox.x + displayBox.width / 2, displayBox.y + displayBox.height / 2);
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        double angle = Math.atan2(y - _center.y, x - _center.x);
        ((TriangleFigure) (owner())).rotate(angle);
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        super.invokeEnd(x, y, anchorX, anchorY, view);
        _center = null;
    }

    @Override
    public Point locate() {
        return getOrigin();
    }

    Point getOrigin() { // find a nice place to put handle
                        // almost same code as PolygonScaleHandle
        Polygon p = ((TriangleFigure) (owner())).outline();
        Point first = new Point(p.xpoints[0], p.ypoints[0]);
        Point ctr = owner().center();
        double len = Geom.length(first.x, first.y, ctr.x, ctr.y);
        if (len == 0) { // best we can do?
            return new Point(first.x - HANDLESIZE / 2, first.y + HANDLESIZE / 2);
        }

        double u = HANDLESIZE / len;
        if (u > 1.0) { // best we can do?
            return new Point((first.x * 3 + ctr.x) / 4, (first.y * 3 + ctr.y) / 4);
        } else {
            return new Point(
                (int) (first.x * (1.0 - u) + ctr.x * u), (int) (first.y * (1.0 - u) + ctr.y * u));
        }
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);

        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}