/*
 * @(#)FontSizeHandle.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Fontkit;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.api.HandleApi;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * A Handle to change the font size by direct manipulation.
 * @deprecated This class is not to be used externally. Please use the method {@link HandleApi#createFontSizeHandle(Figure, Locator)} instead.
 */
@Deprecated
public class FontSizeHandle extends LocatorHandle {
    private Font _font;
    private int _size;
    private int _height;

    /**
     * Constructs a new FontSizeHandle.
     *
     * @param owner the figure to which this handle is attached
     * @param l a locator that determines the handle's position on the figure
     * @deprecated This constructor is not to be used externally. Please use the method {@link HandleApi#createFontSizeHandle(Figure, Locator)} instead.
     */
    @Deprecated
    public FontSizeHandle(Figure owner, Locator l) {
        super(owner, l);
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        TextFigure textOwner = (TextFigure) owner();
        _font = textOwner.getFont();
        _size = _font.getSize();
        Rectangle box = textOwner.displayBox();
        _height = box.height;
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        AffineTransform affineTransform = view.getAffineTransform();
        Point2D p = new Point2D.Double(anchorX, anchorY);
        try {
            affineTransform.inverseTransform(p, p);
        } catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }

        TextFigure textOwner = (TextFigure) owner();
        int newSize = _size * (_height + y - (int) p.getY()) / _height;
        if (newSize > 0) {
            textOwner.setFont(Fontkit.getFont(_font.getName(), _font.getStyle(), newSize));
        }
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);

        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}