/*
 * @(#)InsertImageCommand.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Image;

import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.util.Iconkit;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * Command to insert a named image.
 */
public class InsertImageCommand extends UndoableCommand {
    /**
     * The unused {@code DrawingEditor} of the class to coordinate drawings.
     */
    protected DrawingEditor _editor;

    /**
     * pathName of the Image.
     */
    private final String _fImage;

    /**
     * Creates a new InsertImageCommand.
     *
     * @param name the command name
     * @param image the pathname of the image
     */
    public InsertImageCommand(String name, String image) {
        super(name);
        _fImage = image;
        // fEditor = editor;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();

        // ugly cast to component, but AWT wants a Component instead of an ImageObserver...
        Image image = Iconkit.instance().registerAndLoadImage(null, _fImage);
        ImageFigure figure = new ImageFigure(image, _fImage, view.lastClick());
        view.add(figure);
        view.clearSelection();
        view.addToSelection(figure);
        view.checkDamage();
        return true;
    }
}