/*
 * @(#)NumberTextFigure.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.io.Serial;

/**
 * A TextFigure specialized to edit numbers.
 */
public class NumberTextFigure extends TextFigure {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = -4056859232918336475L;

    /**
     * Serial number for the serialized data format of NumberTextFigures.
     */
    @SuppressWarnings("unused")
    private final int _numberTextFigureSerializedDataVersion = 1;

    /**
     * Creates a new NumberTextFigure.
     */
    public NumberTextFigure() {
        setAlignment(RIGHT);
    }

    /**
     * Gets the number of columns to be used by the text overlay.
     * <p>
     * {@link CH.ifa.draw.util.FloatingTextField}
     *
     * @return number of columns
     */
    public int overlayColumns() {
        return Math.max(4, getText().length());
    }

    /**
     * Gets the numerical value of the contained text.
     * return the value or 0 in the case of an illegal number format.
     *
     * @return numerical value of contained text
     */
    public int getValue() {
        try {
            return Integer.parseInt(getText());
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    /**
     * Sets the numerical value of the contained text.
     *
     * @param value new numerical value of text
     */
    public void setValue(int value) {
        setText(Integer.toString(value));
    }
}