/*
 * @(#)RadiusHandle.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import org.freehep.graphicsio.VectorGraphicsIO;

import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A Handle to manipulate the start/end angle of an arc or pie ellipse
 * segment.
 * <p>
 * </p>
 * Created: 13 Jul 2008
 * @author Michael Duvigneau
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
class PieAngleHandle extends AbstractHandle {
    private double _angle;
    private final PieFigure _pieFig;
    private final int _angleKind;

    public PieAngleHandle(PieFigure owner, int angleKind) {
        super(owner);
        _pieFig = owner;
        this._angleKind = angleKind;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        _angle = _pieFig.getAngle(_angleKind);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = _pieFig.displayBox();
        Point center = new Point(r.x + r.width / 2, r.y + r.height / 2);
        Point from = new Point(x, y);
        double angleRad;
        if (from.equals(center)) {
            angleRad = Math.PI;
        } else {
            angleRad = Geom.pointToAngle(r, from);
        }
        _angle = PieFigure.normalizeAngle(-Math.toDegrees(angleRad));
        if (e.isControlDown()) {
            // With Ctrl-Key, jump to divisions by 15 degrees.
            _angle = (Math.round(_angle / 15) * 15) % 360;
        }
        _pieFig.setAngle(_angleKind, _angle);
    }

    @Override
    public Point locate() {
        Rectangle r = _pieFig.displayBox();
        _angle = _pieFig.getAngle(_angleKind);
        double angleRad = -Math.toRadians(_angle);
        return Geom.ovalAngleToPoint(r, angleRad);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.yellow);
        //we need to draw vector graphics differently for svg and java
        if (g instanceof VectorGraphicsIO) {
            g.fillOval(r.x + 1, r.y + 1, r.width - 1, r.height - 1);
        } else {
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}