/*
 * @(#)PolyLineMiddleLocator.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Point;

import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;

/**
 * A poly line figure consists of a list of points.
 * It has an optional line decoration at the start and end.
 * <p>
 * {@link LineDecoration}
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
class PolyLineSegmentLocator extends AbstractLocator {
    final int _segment;

    public PolyLineSegmentLocator(int segment) {
        _segment = segment;
    }

    @Override
    public Point locate(Figure owner) {
        PolyLineable plf = (PolyLineable) owner;

        // guard against changing PolyLineFigures -> temporary hack
        // might already be solved by DrawingView.selectionHandlesInvalidated()
        if (_segment < plf.pointCount() - 1) {
            return Geom.middle(plf.pointAt(_segment), plf.pointAt(_segment + 1));
        }
        return new Point(0, 0);
    }
}