/*
 * @(#)RectangleFigure.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serial;
import java.util.Vector;

import CH.ifa.draw.standard.BoxHandleKit;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;

/**
 * A rectangle figure.
 */
public class RectangleFigure extends AttributeFigure {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 184722075881789163L;

    /**
     * Determines position and size of the rectangle by
     * specifying position and size of its bounding box.
     *
     * @serial
     **/
    private Rectangle _displayBox;

    /**
     * Unused serial version number.
     */
    @SuppressWarnings("unused")
    private final int _rectangleFigureSerializedDataVersion = 1;

    /**
     * Constructor of the class to create an instance of a RectangleFigure with the
     * origin and corner  at (0, 0).
     */
    public RectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    /**
     * Constructor to create an instance and specify a point of origin and a corner.
     *
     * @param origin point of origin of the RectangleFigure
     * @param corner point of the corner of the RectangleFigure
     */
    public RectangleFigure(Point origin, Point corner) {
        basicDisplayBox(origin, corner);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        _displayBox = new Rectangle(origin);
        _displayBox.add(corner);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(_displayBox.x, _displayBox.y, _displayBox.width, _displayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        _displayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = displayBox();
        Graphics2D g2 = (Graphics2D) g;
        Shape s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = displayBox();
        Graphics2D g2 = (Graphics2D) g;
        Shape s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    //-- store / load ----------------------------------------------
    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(_displayBox.x);
        dw.writeInt(_displayBox.y);
        dw.writeInt(_displayBox.width);
        dw.writeInt(_displayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        _displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}