/*
 * @(#)ScribbleTool.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Point;
import java.awt.event.MouseEvent;

import CH.ifa.draw.standard.UndoableTool;
import de.renew.draw.ui.ontology.DrawingEditor;

/**
 * Tool to scribble a PolyLineFigure.
 * <p>
 * {@link PolyLineFigure}
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class ScribbleTool extends UndoableTool {
    private PolyLineFigure _scribble;

    /**
     * The latest location of the received point.
     */
    private Point _lastPoint;

    /**
     * Flag used to track whether the user has performed a drag action with the scribble tool to draw a shape.
     * Its purpose is to differentiate between a simple click action, which adds a point to the shape, and a drag action.
     */
    private boolean _didDrag = false;

    /**
     * The last point of the MouseDown event.
     */
    private Point _lastMouseDown;

    /**
     * Indicates whether smooth curves should be used in the scribble tool.
     * By default, the value is set to false, meaning points are connected by straight lines.
     */
    public boolean shouldUseSmoothCurves = false;

    /**
     * Normalized smoothness value used when the 'shouldUseSmoothCurves' option is selected.
     * The value ranges from 0.0 to 1.0. By default, the value is set to 0.5.
     */
    public static double smoothness = 0.5;

    /**
     * Creates a new ScribbleTool for drawing polyline figures.
     *
     * @param editor the DrawingEditor context in which this tool operates
     */
    public ScribbleTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        super.activate();
        _scribble = null;
    }

    @Override
    public void deactivate() {
        if (_scribble != null) {
            if (_scribble.size().width < 4 || _scribble.size().height < 4) {
                drawing().remove(_scribble);
                noChangesMade();
            }
        }
        _scribble = null;
        super.deactivate();
    }

    private void point(int x, int y) {
        if (_scribble == null) {
            if (shouldUseSmoothCurves) {
                // A. Create a new instance of SmoothPolyLineFigure
                _scribble = new SmoothPolyLineFigure(x, y, ScribbleTool.smoothness);
            } else {
                // B. Create a new instance of PolyLineFigure.
                _scribble = new PolyLineFigure(x, y);
            }

            view().add(_scribble);
            changesMade();
        } else if (_lastPoint.x != x || _lastPoint.y != y) {
            _scribble.addPoint(x, y);
        }

        _lastPoint = new Point(x, y);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (e.getClickCount() >= 2) {
            editor().toolDone();
        } else {
            // use original event coordinates to avoid
            // suppress that the scribble is constrained to
            // the grid
            // EDIT: For the zooming feature to work we DO need the
            // transformed coordinates
            point(x, y);
        }

        // Store the mouseDown point to check later if user has dragged with the scribble tool
        _lastMouseDown = new Point(x, y);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (_scribble != null) {
            point(x, y);
        }

        // Update the status of didDrag
        Point currentPoint = new Point(x, y);
        if (_lastMouseDown != null) {
            boolean farEnough = currentPoint.distance(_lastMouseDown) > 2;
            if (farEnough) {
                _didDrag = true;
            }
        }

    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);

        // Reset the shape to enable the creation of a new shape after the user has dragged with the scribble tool
        if (_didDrag) {
            _scribble = null;
        }
        _didDrag = false;
    }

}