/*
 * @(#)UngroupCommand.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.util.Vector;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * Command to ungroup the selected figures.
 * {@link GroupCommand}
 * @deprecated This class is only for internal usage and will later be made private.
 */
@Deprecated
public class UngroupCommand extends UndoableCommand {
    // protected DrawingEditor getEditor();

    /**
     * Constructs a group command.
     *
     * @param name the command name
     * @deprecated This constructor is only for internal usage. Please use
     *             {@link de.renew.draw.ui.api.CommandApi#createUnGroupCommand(String)} instead.
     */
    @Deprecated
    public UngroupCommand(String name) {
        super(name);
        // getEditor() = editor;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration selection = view.selectionElements();
        view.clearSelection();

        Vector<Figure> parts = new Vector<>();
        while (selection.hasMoreElements()) {
            Figure selected = selection.nextFigure();
            Figure group = view.drawing().orphan(selected);
            FigureEnumeration k = group.decompose();
            while (k.hasMoreElements()) {
                parts.addElement(k.nextFigure());
            }
        }
        view.addAll(parts);
        view.addToSelectionAll(parts);
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}