package CH.ifa.draw.framework;

import java.awt.Color;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * A command that changes the alpha (transparency) value of a color attribute
 * for all selected figures in the current drawing view.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class AlphaChangeCommand extends UndoableCommand {
    private final String _attribute;
    private final int _value;

    /**
     * Constructs a change attribute command.
     * @param name the command name
     * @param attributeName the name of the attribute to be changed
     * @param value the new attribute value
     */
    public AlphaChangeCommand(String name, String attributeName, int value) {
        super(name);
        _attribute = attributeName;
        _value = value;
    }

    @Override
    protected boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(_attribute);
            if (val instanceof Color c) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), _value);
                f.setAttribute(_attribute, c);
            }
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (getEditor() == EditorApi.getNullDrawingEditor()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}