package CH.ifa.draw.framework;

import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;

/**
 * Listeners of this type can be registered at
 * {@link DrawingTypeManager#addListener(DrawingTypeManagerListener)} and are informed about changes
 * in the set of known drawing types.
 * @author Michael Duvigneau
 * @since Renew 2.0
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public interface DrawingTypeManagerListener {

    /**
     * Called whenever a file type has been registered via
     * {@link DrawingTypeManager#register(String, ExtensionFileFilter)}. It does not matter,
     * whether the registration replaced previously known type
     * information or not.
     *
     * @param name    the registration key.
     * @param filter  the <code>FileFilter</code> object
     *                denoting the file type.
     **/
    void typeRegistered(String name, FileFilter filter);

    /**
     * Called whenever the default file type has been changed via
     * {@link DrawingTypeManager#setDefaultFileFilter(ExtensionFileFilter)}.
     *
     * @param filter  the <code>FileFilter</code> object
     *                denoting the new default file type.
     **/
    void defaultTypeChanged(FileFilter filter);

}