package CH.ifa.draw.framework;

import java.awt.Dimension;
import java.awt.Graphics;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Painter;

/**
 * Interface providing backwards compatibility for the DrawingView type.
 *
 * @deprecated This class is not to be used externally. Please use {@link de.renew.draw.ui.ontology.DrawingView} instead.
 */
@Deprecated
public interface DrawingView extends de.renew.draw.ui.ontology.DrawingView {

    /**
     * Sets the view's editor.
     * @param editor editor to be set
     */
    void setEditor(DrawingEditor editor);

    /**
     * Gets the preferred dimension of the drawing.
     * @return preferred dimension of this drawing
     */
    Dimension getPreferredSize();

    /**
     * Sets the current display update strategy.
     * @param updateStrategy update Strategy to be set
     */
    void setDisplayUpdate(Painter updateStrategy);

    /**
     * Removes a figure from the selection.
     * @param figure figure to be removed from selection
     */
    void removeFromSelection(Figure figure);


    /**
     * Removes an enumeration of figures from the current selection.
     * @param figures figures to be removed
     */
    void removeFromSelectionAll(FigureEnumeration figures);

    /**
     * Toggles an enumeration of figures.
     * If a figure isn't selected it is added to the selection.
     * Otherwise, it is removed from the selection.
     * @param figures figures to be toggled
     */
    void toggleSelectionAll(FigureEnumeration figures);

    /**
     * Paints the drawing view. The actual drawing is delegated to
     * the current update strategy.
     * @param g graphic to be painted in
     * {@link Painter}
     */
    void paint(Graphics g);
}
