package CH.ifa.draw.framework;

import java.util.Vector;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.FigureSelection;

/**
 * Keeps a history of snapshots of a drawing.
 * Provides methods to take a new snapshot and to
 * restore the latest snapshot, the affected drawing
 * is specified at the constructor call.
 * <p>
 * The history is limited to <code>maxSize</code>
 * snapshots, the oldest snapshot will be removed if
 * the limit is exceeded. Currently, the limit cannot
 * be modified after instantiation.
 * </p>
 *
 * SnapshotHistory.java
 * Created: Wed Dec 13  2000
 * @author Michael Duvigneau
 *
 * @deprecated This class is not to be used externally. Please use the {@link de.renew.draw.ui.api.UndoRedoApi} instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class SnapshotHistory implements de.renew.draw.ui.ontology.undoredo.SnapshotHistory {
    private final Vector<FigureSelection> _history;
    private final int _maxSize;
    private final Drawing _drawing;
    private FigureSelection _preparedSnapshot;

    /**
     * Creates a new snapshot history for the given drawing.
     *
     * @param drawing   The history will contain snapshots of
     *                  this drawing only.
     * @param maxSize   Limits the number of snapshots the
     *                  history will remember.
     **/
    public SnapshotHistory(Drawing drawing, int maxSize) {
        this._maxSize = maxSize;
        this._drawing = drawing;
        this._preparedSnapshot = null;
        this._history = new Vector<>(maxSize);
    }

    /**
     * Takes a snapshot of all figures which are currently part
     * of the drawing and appends it to the history.
     * If the history limit is exceeded, the oldest snapshot will
     * be removed from the history.
     **/
    public void takeSnapshot() {
        prepareSnapshot();
        commitSnapshot();
    }

    /**
     * Prepares a snapshot for commitSnapshot().
     * Any previously prepared snapshot will be forgotten.
     **/
    public void prepareSnapshot() {
        _preparedSnapshot = new CH.ifa.draw.framework.FigureSelection(_drawing.figures());
    }

    /**
     * Takes the last prepared snapshot of all figures which are
     * currently part of the drawing and appends it to the history.
     * If the history limit is exceeded, the oldest snapshot will
     * be removed from the history.
     **/
    public void commitSnapshot() {
        if (_preparedSnapshot != null) {
            _history.addElement(_preparedSnapshot);
            _preparedSnapshot = null;
            if (_history.size() > _maxSize) {
                _history.removeElementAt(0);
            }
        }
    }

    /**
     * Restores the latest snapshot of the drawing.
     * Replaces all figures currently contained in the drawing
     * by the figures in the snapshot.
     * <p>
     * If the history is empty, nothing will happen.
     */
    public void restoreSnapshot() {
        if (!_history.isEmpty()) {
            FigureSelection snapshot = _history.lastElement();
            _history.removeElementAt(_history.size() - 1);

            _drawing.removeAll();

            Vector<Figure> restoreFigures = snapshot.getData();
            _drawing.addAll(restoreFigures);

            _drawing.checkDamage();
        }
    }

    /**
     * Removes all snapshots from the history.
     **/
    public void clear() {
        _history.removeAllElements();
    }

    /**
     * Checks whether the history is empty.
     * @return boolean, {@code true} if empty
     **/
    public boolean isEmpty() {
        return _history.isEmpty();
    }
} // UndoHistory
