package CH.ifa.draw.io;

import CH.ifa.draw.io.exportFormats.ExportFormat;


/**
 * This interface must be implemented if you want to add new ExportFormats to Renew.
 * The standard implementation is {@link ExportHolderImpl}.
 * @deprecated This type is not to be used anymore. Please use {@link de.renew.ioontology.exporting.ExportFormatHolder} instead.
 * For the registration and deregistration of drawing export formats, use the methods offered by the {@link de.renew.draw.storables.api.StorableApi}.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public interface ExportHolder {

    /**
     * Adds an ExportFormat to Renew.
     * @require exportFormat != null.
     * @param exportFormat The ExportFormat which is added to Renew.
     */
    public void addExportFormat(ExportFormat exportFormat);

    /**
     * Removes an ExportFormat from Renew.
     * @param exportFormat The ExportFormat to be removed.
     */
    public void removeExportFormat(ExportFormat exportFormat);

    /**
     * Returns an array that contains all ExportFormats added to Renew.
     * @ensure result != null.
     * @return Iterator, Contains all ExportFormats added to Renew.
     */
    public ExportFormat[] allExportFormats();
}