package CH.ifa.draw.io;

import javax.swing.JMenu;

import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatMapper;
import de.renew.draw.storables.impl.drawings.DrawingImportFormatHolder;
import de.renew.draw.ui.impl.menus.ImportMenuHolder;

/**
 * Imports new Import formats to renew
 * @deprecated This class is not to be used externally and will later be removed.
 * Please use the methods offered by the {@link de.renew.draw.storables.api.StorableApi}
 * for the registration and deregistration of drawing import formats instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class ImportHolderImpl implements ImportHolder {
    /**
     * Creates log4j Logger for this class to represent logging information.
     */
    public static org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(ImportHolderImpl.class);



    /**
     * The instance of the ImportMenuHolder that manages the import menu of the application.
     */
    private ImportMenuHolder _importMenuHolder;

    /**
     * Constructs and sets up ImportHolder.
     */
    public ImportHolderImpl() {
        _importMenuHolder = new ImportMenuHolder();
    }

    /**
     * Returns the associated import menu.
     *
     * @return The import menu
     */
    public JMenu getImportMenu() {
        return _importMenuHolder.getImportMenu();
    }

    //	---------------------------------------------------------------------
    // Implementation of the ImportHolder Interface
    // ---------------------------------------------------------------------
    // Methods

    @Override
    public void addImportFormat(ImportFormat importFormat) {
        DrawingImportFormatHolder.getInstance()
            .addImportFormat(ImportFormatMapper.mapImportFormat(importFormat));
    }

    @Override
    public ImportFormat[] allImportFormats() {
        return DrawingImportFormatHolder.getInstance().getImportFormats().stream()
            .map(ImportFormatMapper::mapImportFormat).toArray(ImportFormat[]::new);
    }

    @Override
    public void removeImportFormat(ImportFormat format) {
        DrawingImportFormatHolder.getInstance()
            .removeImportFormat(ImportFormatMapper.mapImportFormat(format));
    }
}