/*
 * @(#)BringToFrontCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * BringToFrontCommand brings the selected figures in the front of
 * the other figures.
 *
 * See {@link SendToBackCommand}.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class BringToFrontCommand extends UndoableCommand {

    /**
     * Constructs a BingToTheFrontCommand.
     * @param name the command name
     */
    public BringToFrontCommand(String name) {
        super(name);
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration k = new FigureEnumerator(view.selectionZOrdered());
        while (k.hasMoreElements()) {
            view.drawing().bringToFront(k.nextFigure());
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}