/*
 * @(#)FigureEnumerator.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;


/**
 * An Enumeration for a Vector of Figures.
 */
public final class FigureEnumerator implements FigureEnumeration {
    final Enumeration<Figure> _enumeration;

    public FigureEnumerator(Vector<Figure> v) {
        _enumeration = v.elements();
    }

    /**
     * Returns true if the enumeration contains more elements; false
     * if its empty.
     */
    @Override
    public boolean hasMoreElements() {
        return _enumeration.hasMoreElements();
    }

    /**
     * Returns the next element of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     */
    @Override
    public Figure nextElement() {
        return _enumeration.nextElement();
    }

    /**
     * Returns the next element of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     */
    @Override
    public Figure nextFigure() {
        return _enumeration.nextElement();
    }
}