package CH.ifa.draw.standard;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.log4j.Logger;


/**
 * Generic info dialog with an OK-button (modal)
 * <br>
 * 05.10.2000 HR
 *
 */
public class InfoDialog extends JDialog {
    private final Logger _logger = Logger.getLogger(InfoDialog.class);
    protected JButton button;
    protected MultiLineLabel label;

    public InfoDialog(JFrame parent, String title, String message) {
        super(parent, title, true);

        getContentPane().setLayout(new BorderLayout(15, 15));

        label = new MultiLineLabel(message, 20, 20);

        getContentPane().add("Center", label);

        button = new JButton("OK");
        ActionListener listener = e -> InfoDialog.this.dispose();
        button.addActionListener(listener);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
        p.add(button);
        getContentPane().add("South", p);

        pack();
    }

    /**
     * Get InfoDialog with JLabel
     *
     * @param title
     * @param parent
     * @param message
     */
    public InfoDialog(JFrame parent, String title, String message, boolean addRenewLink) {
        super(parent, title, true);

        try {
            getContentPane().setLayout(new BorderLayout(15, 15));
            JLabel jLabel = new JLabel("<html>" + message + "</html>");
            jLabel.setOpaque(true);

            JPanel aboutPanel = new JPanel();
            aboutPanel.setLayout(new BoxLayout(aboutPanel, BoxLayout.PAGE_AXIS));
            aboutPanel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
            aboutPanel.add(jLabel);
            aboutPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            createLinkLabel(aboutPanel, "http://www.renew.de", false);
            if (addRenewLink) {
                createLinkLabel(aboutPanel, "http://www.paose.net", false);
            }
            createLinkLabel(aboutPanel, "mailto:support@renew.de", true);

            getContentPane().add("Center", aboutPanel);

            button = new JButton("OK");
            ActionListener listener = e -> InfoDialog.this.dispose();
            button.addActionListener(listener);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
            p.add(button);
            getContentPane().add("South", p);

            pack();
        } catch (Exception e) {
            _logger.error("InfoDialog " + e);
        }
    }

    private JPanel createLinkLabel(JPanel helpPanel, final String url, final boolean mail) {
        final String linkTitle;
        final String linkAddress;

        if (mail) {
            if (url.startsWith("mailto:")) {
                linkTitle = url.replaceFirst("mailto:", "");
                linkAddress = url;
            } else {
                linkTitle = url;
                linkAddress = "mailto:" + url;
            }
        } else {
            linkTitle = url;
            linkAddress = url;
        }

        JLabel pageUrl =
            new JLabel("<html><a href=\"" + linkAddress + "\">" + linkTitle + "</a></html>");
        pageUrl.setCursor(new Cursor(Cursor.HAND_CURSOR));
        pageUrl.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 0) {
                    openURL(linkAddress, mail);
                }
            }
        });
        helpPanel.add(pageUrl);
        return helpPanel;
    }

    private void openURL(String url, boolean mail) {
        try {
            Desktop desktop = Desktop.getDesktop();
            URI uri = URI.create(url);

            if (mail) {
                desktop.mail(uri);
            } else {
                desktop.browse(uri);
            }
        } catch (IOException e) {
            _logger.error(InfoDialog.class.getSimpleName() + ": could not open link " + url + ".");
            if (_logger.isDebugEnabled()) {
                _logger.debug(InfoDialog.class.getSimpleName() + ": " + e);
            }
        }
    }
}