/*
 * @(#)LocatorConnector.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serial;

import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;

/**
 * A LocatorConnector locates connection points with
 * the help of a Locator. It supports the definition
 * of connection points to semantic locations.
 * @see de.renew.draw.storables.ontology.Locator
 * @see Connector
 */
public class LocatorConnector extends AbstractConnector {

    /**
     * The standard size of the connector. The display box
     * is centered around the located point.
     */
    public static final int SIZE = 8;
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 5062833203337604181L;
    private final int _locatorConnectorSerializedDataVersion = 1;

    private Locator _locator;

    public LocatorConnector() { // only used for Storable
        _locator = null;
    }

    public LocatorConnector(Figure owner, Locator l) {
        super(owner);
        _locator = l;
    }

    protected Point locate(ConnectionFigure connection) { //NOTICE signature
        return _locator.locate(owner());
    }

    /**
     * Tests if a point is contained in the connector.
     */
    @Override
    public boolean containsPoint(int x, int y) {
        return displayBox().contains(x, y);
    }

    /**
     * Gets the display box of the connector.
     */
    @Override
    public Rectangle displayBox() {
        Point p = _locator.locate(owner());
        return new Rectangle(p.x - SIZE / 2, p.y - SIZE / 2, SIZE, SIZE);
    }

    /**
     * Draws this connector.
     */
    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.blue);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    /**
     * Stores the arrow tip to a StorableOutput.
     */
    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(_locator);
    }

    /**
     * Reads the arrow tip from a StorableInput.
     */
    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        _locator = (Locator) dr.readStorable();
    }
}