/*
 * @(#)LocatorHandle.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;


/**
 * A LocatorHandle implements a Handle by delegating the location requests to
 * a Locator object.
 *
 * @see Locator
 */
public abstract class LocatorHandle extends AbstractHandle {
    private final Locator _locator;

    /**
     * Initializes the LocatorHandle with the given Locator.
     */
    public LocatorHandle(Figure owner, Locator l) {
        super(owner);
        _locator = l;
    }

    /**
     * Locates the handle on the figure by forwarding the request
     * to its figure.
     */
    @Override
    public Point locate() {
        return _locator.locate(owner());
    }
}