/*
 * @(#)DrawingView.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Vector;

import CH.ifa.draw.util.NullGraphics;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeEvent;
import de.renew.draw.storables.ontology.DrawingChangeListener;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.draw.ui.ontology.FigureSelection;
import de.renew.draw.ui.ontology.PointConstrainer;

/**
 * @deprecated This class is not to be used externally and will later be hidden.
 */
// A class that provides a drawing view that does nothing.
// Useful to erase fields that must not be null.
@Deprecated
public class NullDrawingView implements DrawingView, ImageObserver, DrawingChangeListener {
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private static final Point NULL_POINT = new Point(0, 0);
    /**
     * @deprecated This field is not to be used externally and will later be hidden.
     */
    @Deprecated
    public static final NullDrawingView INSTANCE = new NullDrawingView();

    private NullDrawingView() {}

    @Override
    public Drawing drawing() {
        return NullDrawing.INSTANCE;
    }

    @Override
    public void setDrawing(Drawing d) {}

    @Override
    public DrawingEditor editor() {
        return EditorApi.getNullDrawingEditor();
    }

    @Override
    public Figure add(Figure figure) {
        return figure;
    }

    @Override
    public Figure remove(Figure figure) {
        return figure;
    }

    @Override
    public void addAll(Vector<Figure> figures) {}

    @Override
    public Dimension getSize() {
        return NULL_DIMENSION;
    }

    @Override
    public Vector<Figure> selection() {
        return new Vector<>();
    }

    @Override
    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(new Vector<>());
    }

    @Override
    public Vector<Figure> selectionZOrdered() {
        return new Vector<>();
    }

    @Override
    public int selectionCount() {
        return 0;
    }

    @Override
    public void addToSelection(Figure figure) {}

    @Override
    public void addToSelectionAll(Vector<Figure> figures) {}

    @Override
    public void addToSelectionAll(FigureEnumeration figures) {}

    @Override
    public void removeFromSelectionAll(Vector<Figure> figures) {}

    @Override
    public void toggleSelection(Figure figure) {}

    @Override
    public void toggleSelectionAll(Vector<Figure> figures) {}

    @Override
    public void clearSelection() {}

    @Override
    public void selectionInvalidateHandles() {}

    @Override
    public FigureSelection getFigureSelection() {
        return new CH.ifa.draw.framework.FigureSelection(new Vector<>());
    }

    @Override
    public FigureHandle findHandle(int x, int y) {
        return null;
    }

    @Override
    public Point lastClick() {
        return NULL_POINT;
    }

    @Override
    public Point getCurrentMousePosition() {
        return null;
    }

    @Override
    public void setConstrainer(PointConstrainer p) {}

    @Override
    public PointConstrainer getConstrainer() {
        return null;
    }

    @Override
    public void checkDamage() {}

    @Override
    public void repairDamage() {}

    @Override
    public Image createImage(int width, int height) {
        // Supposedly this method is only called by the update
        // strategy. But I do not call the update strategy and
        // nobody else is supposed to call it. Therefore, it
        // should be safe to return a null. 
        return null;
    }

    @Override
    public Graphics getGraphics() {
        return new NullGraphics();
    }

    @Override
    public Color getBackground() {
        return Color.white;
    }

    @Override
    public void setBackground(Color c) {}

    @Override
    public void drawAll(Graphics g) {}

    @Override
    public void setCursor(Cursor c) {}

    @Override
    public void freezeView() {}

    @Override
    public void unfreezeView() {}

    @Override
    public void moveSelection(int dx, int dy) {}

    @Override
    public boolean imageUpdate(Image img, int inf, int x, int y, int w, int h) {
        return false;
    }

    @Override
    public void drawingInvalidated(DrawingChangeEvent event) {}

    @Override
    public void drawingRequestUpdate(DrawingChangeEvent event) {}

    @Override
    public void showElement(Figure fig) {}

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        return Printable.NO_SUCH_PAGE;
    }

    @Override
    public AffineTransform getAffineTransform() {
        return null;
    }
}