/*
 * @(#)NullHandle.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.api.HandleApi;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A handle that doesn't change the owned figure. Its only purpose is
 * to show feedback that a figure is selected.
 * <hr>
 * <b>Design Patterns</b><P>
 * <img src="images/red-ball-small.gif" width=6 height=6 alt=" o ">
 * <b>NullObject</b><br>
 * NullObject enables to treat handles that don't do
 * anything in the same way as other handles.
 * @deprecated This class is not to be used externally. Please use the method {@link HandleApi#createNullHandle(Figure, Locator)} instead.
 */
@Deprecated
public class NullHandle extends LocatorHandle {

    /**
     * The handle's locator.
     */
    protected Locator _locator;

    /**
     * Creates a NullHandle.
     * @param owner the figure that will get the handles
     * @param locator Locators can be used to locate a position on a figure
     * @deprecated This constructor is not to be used externally. Please use the method {@link HandleApi#createNullHandle(Figure, Locator)} instead.
     */
    @Deprecated
    public NullHandle(Figure owner, Locator locator) {
        super(owner, locator);
    }

    /**
     * Tells the undo support that no changes are made.
     */
    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        noChangesMade();
    }

    /**
     * Draws the NullHandle. NullHandles are drawn as a
     * red framed rectangle.
     */
    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    /**
     * Tests if a point is contained in the handle.
     */
    @Override
    public boolean containsPoint(int x, int y) {
        return false; // never report to contain point!
    }
}