/*
 * @(#)OffsetLocator.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;
import java.io.IOException;
import java.io.Serial;

import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;

/**
 * A locator to offset another Locator.
 * @see Locator
 * @deprecated This class is not to be used externally. Please use the methods in {@link StorableApi} instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class OffsetLocator extends AbstractLocator {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 2679950024611847621L;
    private final int _offsetLocatorSerializedDataVersion = 1;

    private Locator _base;
    private int _offsetX;
    private int _offsetY;

    public OffsetLocator() {
        _base = null;
        _offsetX = 0;
        _offsetY = 0;
    }

    /**
     * Creates an OffsetLocator.
     * @param base the origin position that the offset will be later added on
     * @deprecated This constructor is not to be used externally. Please use the method {@link StorableApi#createOffsetLocator(Locator)} instead.
     */
    @Deprecated(since = "5.0", forRemoval = true)
    public OffsetLocator(Locator base) {
        this();
        _base = base;
    }

    /**
     * Creates an OffsetLocator with a predefined offset on the x-axis and y-axis.
     * @param base the origin position that the offset will be later added on
     * @param offsetX offset on the x-axis
     * @param offsetY offset on the y-axis
     * @deprecated This constructor is not to be used externally. Please use the method {@link StorableApi#createOffsetLocator(Locator, int, int)} instead.
     */
    @Deprecated(since = "5.0", forRemoval = true)
    public OffsetLocator(Locator base, int offsetX, int offsetY) {
        this(base);
        _offsetX = offsetX;
        _offsetY = offsetY;
    }

    @Override
    public Point locate(Figure owner) {
        Point p = _base.locate(owner);
        p.x += _offsetX;
        p.y += _offsetY;
        return p;
    }

    public void setBase(Locator base) {
        _base = base;
    }

    public void moveBy(int dx, int dy) {
        _offsetX += dx;
        _offsetY += dy;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(_offsetX);
        dw.writeInt(_offsetY);
        dw.writeStorable(_base);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        _offsetX = dr.readInt();
        _offsetY = dr.readInt();
        _base = (Locator) dr.readStorable();
    }
}