/*
 * @(#)ChangeAttributeCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * Command to change a named figure attribute.
 * <p>
 * The command's effects are undoable step by step.
 * Each use of the apply button can be undone separately.
 * So this command doesn't need to inherit UndoableCommand.
 * </p>
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class QueryAttributeCommand extends ChooseAttributeCommand {
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(QueryAttributeCommand.class);
    JTextField _input;

    /**
     * Constructs a query attribute command.
     * @param displayName the dialog name
     * @param name the command name
     * @param attributeName the name of the attribute to be changed
     * @param type the attribute type (class)
     */
    public QueryAttributeCommand(
        String displayName, String name, String attributeName, Class<?> type)
    {
        super(displayName, name, attributeName, type);

    }

    @Override
    protected void specializeDialog() {
        _input = new JTextField();
        dialog.getContentPane().add(_input, BorderLayout.CENTER);
        //NOTICE redundant
        _input.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ENTER) {
                    apply();
                } else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    closeDialog(dialog);
                }
            }
        });
        dialog.pack();
    }

    @Override
    protected void updateFromFigure() {
        DrawingView view = getEditor().view();
        Object value = null;
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(fAttribute);
            if (val != null) {
                if (value != null && !value.equals(val)) {
                    // different values, use previous value
                    value = null;
                    break;
                }
                value = val;
            }
        }
        String valueStr = "";
        if (value != null) {
            valueStr = value.toString();
        }
        _input.setText(valueStr);
        resetFocus();
    }

    /**
     * After call of this method the JTextField input has the focus
     * and its text is selected.
     */
    private void resetFocus() {
        _input.requestFocus();
        _input.setSelectionStart(0);
        _input.setSelectionEnd(_input.getText().length());
    }

    @Override
    protected void apply() {
        String valueStr = _input.getText();
        Object value = null;
        try {
            if (type == Integer.class) {
                value = Integer.valueOf(valueStr);
            } else if (type == String.class) {
                if (fAttribute.equals("LineStyle")
                    && (valueStr.startsWith("0") || !(valueStr.matches("(\\d+( \\d+)*)?")))) {
                    LOGGER.error(
                        "In the '" + displayName
                            + "' dialog only numbers separated by a dash or a gap are allowed. "
                            + "String should not start with 0 (zero).");
                } else {
                    value = valueStr;
                }
            }
        } catch (NumberFormatException ex) {
            LOGGER.error(ex.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(QueryAttributeCommand.class.getSimpleName() + ": \n" + ex);
            }
        }
        if (value != null) {
            new ChangeAttributeCommand("", fAttribute, value).execute();
        }
        resetFocus();
    }
}