package CH.ifa.draw.standard;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

import CH.ifa.draw.figures.ScribbleTool;



/**
 * The ScribbleOptionPanel class represents a panel that allows the user to configure options for the scribble tool.
 * It provides radio buttons to select the type of scribble tool and a slider to adjust the smoothness value.
 * The selected options and smoothness value can be accessed through the ScribbleTool class.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class ScribbleOptionPanel extends JPanel {
    /**
     * The current scribble tool
     */
    private final ScribbleTool _scribbleTool;

    /**
     * Radio button for selecting the "Raw" option.
     */
    private final JRadioButton _rawRadioButton;

    /**
     * Radio button for selecting the "Smooth" option.
     */
    private final JRadioButton _smoothRadioButton;

    /**
     * Slider for adjusting the smoothness value if the "Smooth" option has been selected
     */
    private final JSlider _slider;

    /**
     * Constructs a new ScribbleOptionPanel.
     */
    public ScribbleOptionPanel(ScribbleTool scribbleTool) {
        super(new GridBagLayout());
        this._scribbleTool = scribbleTool;

        _rawRadioButton = createRadioButton("Raw", !scribbleTool.shouldUseSmoothCurves);
        _smoothRadioButton = createRadioButton("Smooth", scribbleTool.shouldUseSmoothCurves);
        _slider = createSlider();

        setupUI();
    }

    /**
     * Set up the UI of the Panel
     */
    private void setupUI() {
        setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

        // Setup radio buttons
        configureRadioButtonActionListeners();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(_rawRadioButton);
        buttonGroup.add(_smoothRadioButton);
        // Setup label for slider
        JLabel sliderTitle = new JLabel("Smoothness:");

        // Pack elements to a grid
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        add(_rawRadioButton, gbc);

        gbc.gridy = 1;
        add(_smoothRadioButton, gbc);

        gbc.gridy = 2;
        gbc.gridx = 0;
        add(sliderTitle, gbc);

        gbc.gridx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        add(_slider, gbc);
    }

    /**
     * Creates a new JRadioButton with the specified text and selection state.
     * @param text     the text to be displayed on the radio button
     * @param selected the initial selection state of the radio button
     * @return the created JRadioButton
     */
    private JRadioButton createRadioButton(String text, boolean selected) {
        JRadioButton radioButton = new JRadioButton(text);
        radioButton.setSelected(selected);
        return radioButton;
    }

    /**
     * Creates a new JSlider for adjusting the smoothness value.
     * @return the created JSlider
     */
    private JSlider createSlider() {
        JSlider slider = new JSlider();
        slider.setPreferredSize(new Dimension(100, slider.getPreferredSize().height));
        slider.addChangeListener(e -> {
            int value = slider.getValue();
            ScribbleTool.smoothness = (double) value / 100;
        });
        slider.setEnabled(false);
        return slider;
    }

    /**
     * Configures action listeners for the radio buttons.
     * Enables or disables the slider based on the selected shape type of the scribble tool
     */
    private void configureRadioButtonActionListeners() {
        _rawRadioButton.addActionListener(e -> updateScribbleToolOptions(false));
        _smoothRadioButton.addActionListener(e -> updateScribbleToolOptions(true));
    }

    /**
     * Updates the smoothness value and enables or disables the slider based on the selected radio button.
     * @param useSmoothCurves true if the "Smooth" option is selected, false otherwise
     */
    private void updateScribbleToolOptions(boolean useSmoothCurves) {
        _scribbleTool.shouldUseSmoothCurves = useSmoothCurves;
        _slider.setEnabled(_smoothRadioButton.isSelected());

        int value = _slider.getValue();
        ScribbleTool.smoothness = (double) value / 100;
    }
}