/*
 * @(#)SendToBackCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A command to send the selection to the back of the drawing.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class SendToBackCommand extends UndoableCommand {
    /**
     * Constructs a SendToBackCommand.
     * @param name the command name
     */
    public SendToBackCommand(String name) {
        super(name);
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration k = new ReverseFigureEnumerator(view.selectionZOrdered());
        while (k.hasMoreElements()) {
            view.drawing().sendToBack(k.nextFigure());
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}