/**
 *
 */

package CH.ifa.draw.standard;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * @author Cabac
 *
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class SetLineWidthCommand extends UndoableCommand {
    private final int _width;

    public SetLineWidthCommand(String name, int i) {
        super(name);
        _width = i;
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.framework.UndoableCommand#executeUndoable()
     */
    @Override
    protected boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            f.setAttribute(AttributeFigure.LINE_WIDTH_KEY, _width);
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (getEditor() == EditorApi.getNullDrawingEditor()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}