package CH.ifa.draw.standard;

import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;

import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;

import CH.ifa.draw.framework.DrawingViewDecoration;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.DrawingViewContainer;

public class StandardDrawingViewFactory
    implements MultipleCDockableFactory<StandardDrawingViewContainer, DrawingLayoutWrapper>
{

    protected final StandardDrawingEditor fEditor;
    private final List<DrawingViewDecoration> _decorations = new LinkedList<>();

    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(StandardDrawingViewFactory.class);

    public StandardDrawingViewFactory(StandardDrawingEditor editor) {
        fEditor = editor;
        AttributeMenuDecoration attributeMenuDecoration = new AttributeMenuDecoration();
        editor.registerSelectionChangeListener(attributeMenuDecoration);
        this.addDecoration(attributeMenuDecoration);
    }

    @Override
    public DrawingLayoutWrapper write(StandardDrawingViewContainer standardDrawingViewContainer) {
        return new DrawingLayoutWrapper(standardDrawingViewContainer.getView().drawing());
    }

    @Override
    public StandardDrawingViewContainer read(DrawingLayoutWrapper layout) {

        LOGGER.debug("Creating a new view container for a drawing.");

        Drawing drawing = layout.drawing();
        StandardDrawingView view = createViewFromDrawing(drawing);
        view.setDrawing(drawing);
        StandardDrawingViewContainer container = new StandardDrawingViewContainer(this, view);
        container.setTitleText(drawing.getName());

        LOGGER.debug("Adding additional decorations to view container.");
        addDecorations(container);

        return container;
    }

    protected StandardDrawingView createViewFromDrawing(Drawing drawing) {
        Dimension d = drawing.defaultSize();
        return new StandardDrawingView(fEditor, d.width, d.height);
    }

    @Override
    public boolean match(
        StandardDrawingViewContainer standardDrawingViewContainer, DrawingLayoutWrapper layout)
    {
        Drawing drawing = layout.drawing();
        return standardDrawingViewContainer.getView().drawing().equals(drawing);
    }

    @Override
    public DrawingLayoutWrapper create() {
        return new DrawingLayoutWrapper(new StandardDrawing());
    }

    /**
     * Register a new decoration with which every new {@link DrawingViewContainer} provided by this factory will be decorated.
     *
     * @param decoration
     */
    public void addDecoration(DrawingViewDecoration decoration) {
        _decorations.add(decoration);
    }

    protected void addDecorations(StandardDrawingViewContainer container) {

        LinkedList<CAction> actions;

        for (DrawingViewDecoration decoration : _decorations) {
            actions = decoration.getDecorations();

            for (CAction action : actions) {
                container.addAction(action);
            }
            container.addSeparator();
        }
    }
}
